#title:如何配置 web.xml
#author:zozoh(zozohtnt@gmail.com)
#index:0,1
------------------------------------------------------------------------
在 web.xml 中，一个比较典型的例子：

	{{{<xml>
    <filter>
        <filter-name>nutz</filter-name>
        <filter-class>org.nutz.mvc.NutFilter</filter-class>
        <init-param>
            <param-name>modules</param-name>
            <param-value>com.mine.app.MainModule</param-value>
        </init-param>
    </filter>

    <filter-mapping>
        <filter-name>nutz</filter-name>
        <url-pattern>/*</url-pattern>
    </filter-mapping>
	}}}

 	* 如果你没有声明 '{*modules}' 参数，这个过滤器将不会映射 URL，但是它并不会抛异常
 	* 默认的，只要被正则式 {* `"^(.+[.])(jsp|png|gif|jpg|js|css|jspx|jpeg)$"`} \
 	  匹配上的 URL 都不会被 Nutz 过滤器处理
 	* 你可以为 NutFilter 设置参数 "ignore"，来重新设置这个正则表达式
 	* 如果你的值是 "null" （不区分大小写），所有的请求都会转发到 Nutz.mvc 进行处理
 	* 如果 Nutz.mvc 没有找到合适入口函数处理,将会继续 chain.doFilter

	比如如果你想忽略所有的 .html 请求，你可以
	{{{<xml>
		<filter>
			<filter-name>nutz</filter-name>
			<filter-class>org.nutz.mvc.NutFilter</filter-class>
			<init-param>
				<param-name>modules</param-name>
				<param-value>com.mine.app.MainModule</param-value>
			</init-param>
			<init-param>
				<param-name>ignore</param-name>
				<param-value>^(.+[.])(jsp|png|gif|jpg|js|css|jspx|jpeg|html)$</param-value>
			</init-param>
		</filter>
	}}}

 	注意,如果你使用[view.man Forward视图],请这样写filter-mapping
 	{{{
 	<filter-mapping>
    	<filter-name>nutz</filtername>
    	<url-pattern>/*</url-pattern>
    	<dispatcher>REQUEST</dispatcher>
    	<dispatcher>FORWARD</dispatcher>
	</filter-mapping>
 	}}}

比较传统的方式
	{{{<xml>
	<filter>
	    <filter-name>msgs</filter-name>
	    <filter-class>org.nutz.mvc.NutFilter</filter-class>
	    <init-param>
	        <param-name>skip-mode</param-name>
	        <param-value>true</param-value>
	    </init-param>
    </filter>
	<filter-mapping>
	    <filter-name>msgs</filter-name>
	    <url-pattern>*.jsp</url-pattern>
    </filter-mapping>
        
    <servlet>
	    <servlet-name>nutz</servlet-name>
	        <servlet-class>org.nutz.mvc.NutServlet</servlet-class>
	        <init-param>
		        <param-name>modules</param-name>
		        <param-value>your.package.MainModule</param-value>
            </init-param>
            <load-on-startup>1</load-on-startup>
        </servlet>
		<servlet-mapping>
		    <servlet-name>nutz</servlet-name>
		    <url-pattern>*.nut</url-pattern>
        </servlet-mapping>
	}}}
	
