﻿using Prism.Forms.Tests.Mocks.Views;
using Prism.Navigation;
using System.Reflection;
using Xunit;

namespace Prism.Forms.Tests.Navigation
{
    public class PageNavigationRegistryFixture
    {
        [Fact]
        public void RegisterPageForNavigation()
        {
            ResetPageNavigationRegistry();

            var name = "MainPage";
            var type = typeof(PageMock);
            PageNavigationRegistry.Register(name, type);

            var info = PageNavigationRegistry.GetPageNavigationInfo(name);

            Assert.NotNull(info);
        }

        [Fact]
        public void NavigationInfoIsNullForUnregisteredPage()
        {
            var name = "UnRegisteredPage";
            var info = PageNavigationRegistry.GetPageNavigationInfo(name);

            Assert.Null(info);
        }

        [Fact]
        public void GetPageType()
        {
            ResetPageNavigationRegistry();

            var name = "MainPage";
            var type = typeof(PageMock);
            PageNavigationRegistry.Register(name, type);

            var infoType = PageNavigationRegistry.GetPageType(name);

            Assert.Equal(type, infoType);
        }

        [Fact]
        public void PageTypeIsNullForUnregisteredPage()
        {
            var name = "UnRegisteredPage";
            var infoType = PageNavigationRegistry.GetPageType(name);

            Assert.Null(infoType);
        }

        public static void ResetPageNavigationRegistry()
        {
            TypeInfo staticType = typeof(PageNavigationRegistry).GetTypeInfo();

            ConstructorInfo ci = null;

            foreach (var ctor in staticType.DeclaredConstructors)
            {
                ci = ctor;
                continue;
            }

            object[] parameters = new object[0];
            ci.Invoke(null, parameters);
        }
    }
}
