﻿using Ninject;
using Ninject.Parameters;
using Ninject.Planning.Bindings.Resolvers;
using Prism.AppModel;
using Prism.Behaviors;
using Prism.Common;
using Prism.Events;
using Prism.Logging;
using Prism.Modularity;
using Prism.Mvvm;
using Prism.Navigation;
using Prism.Ninject.Modularity;
using Prism.Ninject.Navigation;
using Prism.Services;
using Xamarin.Forms;
using DependencyService = Prism.Services.DependencyService;

namespace Prism.Ninject
{
    public abstract class PrismApplication : PrismApplicationBase<IKernel>
    {
        const string _navigationServiceName = "NinjectPageNavigationService";

        public PrismApplication(IPlatformInitializer initializer = null) : base(initializer) { }

        protected override void ConfigureViewModelLocator()
        {
            ViewModelLocationProvider.SetDefaultViewModelFactory((view, type) =>
            {
                IParameter[] overrides = null;

                var page = view as Page;
                if (page != null)
                {
                    overrides = new IParameter[]
                    {
                        new ConstructorArgument("navigationService", CreateNavigationService(page))
                    };
                }

                return Container.Get(type, overrides);
            });
        }

        protected override IKernel CreateContainer()
        {
            return new StandardKernel();
        }

        protected override IModuleManager CreateModuleManager()
        {
            return Container.Get<IModuleManager>();
        }

        protected override INavigationService CreateNavigationService()
        {
            return Container.Get<INavigationService>(_navigationServiceName);
        }

        protected override void ConfigureContainer()
        {
            Container.Bind<ILoggerFacade>().ToConstant(Logger).InSingletonScope();
            Container.Bind<IModuleCatalog>().ToConstant(ModuleCatalog).InSingletonScope();

            Container.Bind<IApplicationProvider>().To<ApplicationProvider>().InSingletonScope();
            Container.Bind<IApplicationStore>().To<ApplicationStore>().InSingletonScope();
            Container.Bind<INavigationService>().To<NinjectPageNavigationService>().Named(_navigationServiceName);
            Container.Bind<IModuleManager>().To<ModuleManager>().InSingletonScope();
            Container.Bind<IModuleInitializer>().To<NinjectModuleInitializer>().InSingletonScope();
            Container.Bind<IEventAggregator>().To<EventAggregator>().InSingletonScope();
            Container.Bind<IDependencyService>().To<DependencyService>().InSingletonScope();
            Container.Bind<IPageDialogService>().To<PageDialogService>().InSingletonScope();
            Container.Bind<IDeviceService>().To<DeviceService>().InSingletonScope();
            Container.Bind<IPageBehaviorFactory>().To<PageBehaviorFactory>().InSingletonScope();            
        }
    }
}
