---
title: "C# | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "documentation [C#]"
  - "Help, Visual C# documentation"
  - "C# language"
  - "Visual C#"
ms.assetid: 7f4f8103-7068-4f1d-92c7-3c4519b6edbc
caps.latest.revision: 47
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# C#
C# (pronounced "C sharp") is a programming language that is designed for building a variety of applications that run on the .NET Framework. C# is simple, powerful, type-safe, and object-oriented. The many innovations in C# enable rapid application development while retaining the expressiveness and elegance of C-style languages.  
  
 If you don't already have C#, you can acquire a version of Visual Studio that includes C# for free from the [Visual Studio](https://www.visualstudio.com/products/free-developer-offers-vs) site.  
  
## In This Section  
 [Getting Started with C#](../csharp/getting-started/getting-started-with-csharp.md)  
 Introduces the features of C# for programmers who are new to the language or are new to [!INCLUDE[vsprvs](../csharp/includes/vsprvs_md.md)], and provides a roadmap for finding Help about [!INCLUDE[vsprvs](../csharp/includes/vsprvs_md.md)].  
  
 [Using the Visual Studio Development Environment for C#](https://docs.microsoft.com/visualstudio/csharp-ide/using-the-visual-studio-development-environment-for-csharp)  
 Introduces the [!INCLUDE[csprcs](../csharp/includes/csprcs_md.md)] development environment.  
  
 [C# Programming Guide](../csharp/programming-guide/index.md)  
 Provides information and practical examples about how to use C# language constructs.  
  
 [C# Reference](../csharp/language-reference/index.md)  
 Provides detailed reference information about C# programming concepts, keywords, types, operators, attributes, preprocessor directives, compiler switches, compiler errors, and compiler warnings.  
  
 [C# Samples](http://code.msdn.microsoft.com/site/search?f%5B0%5D.Type=ProgrammingLanguage&f%5B0%5D.Value=C%23&f%5B0%5D.Text=C%23)  
 MSDN Code Gallery filtered for C#.  
  
 [Walkthroughs](../csharp/walkthroughs.md)  
 Provides links to programming walkthroughs that use C# and a brief description of each walkthrough.  
  
## Related Sections  
 [C# Language Specification](../csharp/language-reference/language-specification.md)  
 Links to the latest version of the C# Specifications in Microsoft Word format.  
  
## See Also  
 [Getting Started with Visual C# and Visual Basic](https://docs.microsoft.com/visualstudio/ide/getting-started-with-visual-csharp-and-visual-basic)   
 [.NET Development](https://msdn.microsoft.com/library/ff361664)