---
title: "Compiler Error CS0592 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0592"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0592"
ms.assetid: 805c8cf0-eca2-4040-badd-a9c09ab5c747
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0592
Attribute 'attribute' is not valid on this declaration type. It is valid on 'type' declarations only.  
  
 When you define an attribute, you define what constructs it can be applied to by specifying an `AttributeTargets` value. In the following example, the `MyAttribute` attribute can be applied to interfaces only, because the `AttributeUsage` attribute specifies `AttributeTargets.Iterface`. The error is generated because the attribute is applied to a class (class `A`).  
  
## Example  
 The following sample generates CS0592:  
  
```  
// CS0592.cs  
using System;  
  
[AttributeUsage(AttributeTargets.Interface)]  
public class MyAttribute : Attribute   
{  
}  
  
[MyAttribute]  
// Generates CS0592 because MyAttribute is not valid for a class.   
public class A    
{  
    public static void Main()  
    {  
    }  
}  
```  
  
## See Also  
 [Attributes](../../../csharp/programming-guide/concepts/attributes/index.md)