---
title: "Compiler Warning (level 3) CS0675 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0675"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0675"
ms.assetid: 7465dd8d-2543-44f6-b76b-fcae0ef2580d
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 3) CS0675
Bitwise-or operator used on a sign-extended operand; consider casting to a smaller unsigned type first  
  
 The compiler implicitly widened and sign-extended a variable, and then used the resulting value in a bitwise OR operation. This can result in unexpected behavior.  
  
 The following sample generates CS0675:  
  
```  
// CS0675.cs  
// compile with: /W:3  
using System;  
  
public class sign  
{  
   public static void Main()  
   {  
      int hi = 1;  
      int lo = 1;  
      long value = (((long)hi) << 32) | lo;              // CS0675  
      // try the following line instead  
      // long value = (((long)hi) << 32) | ((uint)lo);   // correct  
   }  
}  
```