---
title: "Compiler Error CS0686 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0686"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0686"
ms.assetid: 821ea0c9-87d8-4902-8f0b-dcad72312132
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0686
Accessor 'accessor' cannot implement interface member 'member' for type 'type'. Use an explicit interface implementation.  
  
 Suggested: This error can occur when implementing an interface that contains method names which conflict with the auto-generated methods associated with a property or event. The get/set methods for properties are generated as get_property and set_property, and the add/remove methods for events are generated as add_event and remove_event. If an interface contains either of these methods, a conflict occurs. To avoid this error, implement the methods using an explicit interface implementation. To do this, specify the function as:  
  
```  
  
      Interface.get_property() { /* */ }  
Interface.set_property() { /* */ }  
```  
  
## Example  
 The following sample generates CS0686:  
  
```  
// CS0686.cs  
interface I  
{  
    int get_P();  
}  
  
class C : I  
{  
    public int P  
    {  
        get { return 1; }  // CS0686  
    }  
}  
// But the following is valid:  
class D : I  
{  
    int I.get_P() { return 1; }  
    public static void Main() {}  
}  
```  
  
## Example  
 This error can also occur when declaring events.  The event construct automatically generates the `add_``event` and `remove_``event` methods, which could conflict with the methods of the same name in an interface, as in the following sample:  
  
```  
// CS0686b.cs  
using System;  
  
interface I  
{  
    void add_OnMyEvent(EventHandler e);  
}  
  
class C : I  
{  
    public event EventHandler OnMyEvent  
    {  
        add { }  // CS0686  
        remove { }  
    }  
}  
  
// Correct (using explicit interface implementation):  
class D : I  
{  
    void I.add_OnMyEvent(EventHandler e) {}  
    public static void Main() {}  
}  
```