---
title: "Compiler Error CS1546 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1546"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1546"
ms.assetid: 15fe2cdc-954f-4c67-80fd-9903c464f361
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1546
Property, indexer, or event 'property' is not supported by the language; try directly calling accessor method 'accessor'  
  
 Your code is consuming an object that has a default indexed property and tried to use the indexed syntax. To resolve this error, call the property's accessor method. For more information on indexers and properties, see [Indexers](../../../csharp/programming-guide/indexers/index.md).  
  
 The following sample generates CS1546.  
  
## Example  
 This code sample consists of a .cpp file, which compiles to a .dll, and a .cs file, which uses that .dll. The following code is for the .dll file, and defines a property to be accessed by the code in the .cs file.  
  
```  
// CPP1546.cpp  
// compile with: /clr /LD  
using namespace System;  
public ref class MCPP  
{  
public:  
    property int Prop [int,int]  
    {  
        int get( int i, int b )  
        {  
            return i;  
        }  
    }  
};  
```  
  
## Example  
 This is the C# file.  
  
```  
// CS1546.cs  
// compile with: /r:CPP1546.dll   
using System;  
public class Test  
{  
    public static void Main()  
    {  
        int i = 0;  
        MCPP mcpp = new MCPP();  
        i = mcpp.Prop(1,1); // CS1546  
        // Try the following line instead:  
        // i = mcpp.get_Prop(1,1);  
    }  
}  
```