---
title: "Compiler Error CS1579 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1579"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1579"
ms.assetid: 1eba84ce-58df-4fe3-9134-e26efefdc4ab
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1579
foreach statement cannot operate on variables of type 'type1' because 'type2' does not contain a public definition for 'identifier'  
  
 To iterate through a collection using the [foreach](../../../csharp/language-reference/keywords/foreach-in.md) statement, the collection must meet the following requirements:  
  
-   It must be an interface, class or struct.  
  
-   It must include a public <xref:System.Collections.IEnumerable.GetEnumerator%2A> method that returns a type.  
  
-   The return type must contain a public property named <xref:System.Collections.IEnumerator.Current%2A>, and a public method named <xref:System.Collections.IEnumerator.MoveNext%2A>.  
  
-   For more information, see [How to: Access a Collection Class with foreach](../../../csharp/programming-guide/classes-and-structs/how-to-access-a-collection-class-with-foreach.md).  
  
## Example  
 In this sample, [foreach](../../../csharp/language-reference/keywords/foreach-in.md) is not able to iterate through the collection because there is no `public`<xref:System.Collections.IEnumerable.GetEnumerator%2A> method in `MyCollection`.  
  
 The following sample generates CS1579.  
  
```  
// CS1579.cs  
using System;  
public class MyCollection   
{  
   int[] items;  
   public MyCollection()   
   {  
      items = new int[5] {12, 44, 33, 2, 50};  
   }  
  
   // Delete the following line to resolve.  
   MyEnumerator GetEnumerator()  
  
   // Uncomment the following line to resolve:  
   // public MyEnumerator GetEnumerator()   
   {  
      return new MyEnumerator(this);  
   }  
  
   // Declare the enumerator class:  
   public class MyEnumerator   
   {  
      int nIndex;  
      MyCollection collection;  
      public MyEnumerator(MyCollection coll)   
      {  
         collection = coll;  
         nIndex = -1;  
      }  
  
      public bool MoveNext()   
      {  
         nIndex++;  
         return(nIndex < collection.items.GetLength(0));  
      }  
  
      public int Current   
      {  
         get   
         {  
            return(collection.items[nIndex]);  
         }  
      }  
   }  
  
   public static void Main()   
   {  
      MyCollection col = new MyCollection();  
      Console.WriteLine("Values in the collection are:");  
      foreach (int i in col)   // CS1579  
      {  
         Console.WriteLine(i);  
      }  
   }  
}  
```