---
title: "Query Keywords (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "query keywords [C#]"
  - "LINQ [C#], query keywords"
ms.assetid: 6c9bec16-dbd7-4a7c-a060-fe4600b2021f
caps.latest.revision: 15
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Query Keywords (C# Reference)
This section contains the contextual keywords used in query expressions.  
  
## In This Section  
  
|Clause|Description|  
|------------|-----------------|  
|[from](../../../csharp/language-reference/keywords/from-clause.md)|Specifies a data source and a range variable (similar to an iteration variable).|  
|[where](../../../csharp/language-reference/keywords/where-clause.md)|Filters source elements based on one or more Boolean expressions separated by logical AND and OR operators ( `&&` or `&#124;&#124;` ).|  
|[select](../../../csharp/language-reference/keywords/select-clause.md)|Specifies the type and shape that the elements in the returned sequence will have when the query is executed.|  
|[group](../../../csharp/language-reference/keywords/group-clause.md)|Groups query results according to a specified key value.|  
|[into](../../../csharp/language-reference/keywords/into.md)|Provides an identifier that can serve as a reference to the results of a join, group or select clause.|  
|[orderby](../../../csharp/language-reference/keywords/orderby-clause.md)|Sorts query results in ascending or descending order based on the default comparer for the element type.|  
|[join](../../../csharp/language-reference/keywords/join-clause.md)|Joins two data sources based on an equality comparison between two specified matching criteria.|  
|[let](../../../csharp/language-reference/keywords/let-clause.md)|Introduces a range variable to store sub-expression results in a query expression.|  
|[in](../../../csharp/language-reference/keywords/in.md)|Contextual keyword in a [join](../../../csharp/language-reference/keywords/join-clause.md) clause.|  
|[on](../../../csharp/language-reference/keywords/on.md)|Contextual keyword in a [join](../../../csharp/language-reference/keywords/join-clause.md) clause.|  
|[equals](../../../csharp/language-reference/keywords/equals.md)|Contextual keyword in a [join](../../../csharp/language-reference/keywords/join-clause.md) clause.|  
|[by](../../../csharp/language-reference/keywords/by.md)|Contextual keyword in a [group](../../../csharp/language-reference/keywords/group-clause.md) clause.|  
|[ascending](../../../csharp/language-reference/keywords/ascending.md)|Contextual keyword in an [orderby](../../../csharp/language-reference/keywords/orderby-clause.md) clause.|  
|[descending](../../../csharp/language-reference/keywords/descending.md)|Contextual keyword in an [orderby](../../../csharp/language-reference/keywords/orderby-clause.md) clause.|  
  
## See Also  
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [LINQ (Language-Integrated Query)](http://msdn.microsoft.com/library/a73c4aec-5d15-4e98-b962-1274021ea93d)   
 [LINQ Query Expressions](../../../csharp/programming-guide/linq-query-expressions/index.md)   
 [Getting Started with LINQ in C#](../../../csharp/programming-guide/concepts/linq/getting-started-with-linq.md)