---
title: "! Operator (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "!_CSharpKeyword"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "! operator [C#]"
  - "logical negation operator (!) [C#]"
  - "NOT operator [C#]"
ms.assetid: f5ae133f-8f64-4560-b34f-cd9cd5eed4ad
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# ! Operator (C# Reference)
The logical negation operator (`!`) is a unary operator that negates its operand. It is defined for `bool` and returns `true` if and only if its operand is `false`.  
  
## Remarks  
 User-defined types can overload the `!` operator (see [operator](../../../csharp/language-reference/keywords/operator.md)).  
  
## Example  
 [!code-cs[csRefOperators#7](../../../csharp/language-reference/operators/codesnippet/CSharp/logical-negation-operator_1.cs)]  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Operators](../../../csharp/language-reference/operators/index.md)