---
title: "LINQ in C#"
description: Links to topics that provide more detailed information about LINQ.
keywords: .NET, .NET Core, C#
author: stevehoag
manager: wpickett
ms.author: wiwagn
ms.date: 11/30/2016
ms.topic: article
ms.prod: .net-core
ms.technology: .net-core-technologies
ms.devlang: dotnet
ms.assetid: 8eb3284f-0ab9-4cad-9216-2da58d9761a5
---
# LINQ in C#
This section contains links to topics that provide more detailed information about LINQ.  
  
## In this section  
 [Introduction to LINQ queries](../programming-guide/concepts/linq/introduction-to-linq-queries.md)  
 Describes the three parts of the basic LINQ query operation that are common across all languages and data sources.  
  
 [LINQ and generic types](../programming-guide/concepts/linq/linq-and-generic-types.md)  
 Provides a brief introduction to generic types as they are used in LINQ.  
  
 [Data transformations with LINQ](../programming-guide/concepts/linq/data-transformations-with-linq.md)  
 Describes the various ways that you can transform data retrieved in queries.  
  
 [Type relationships in LINQ query operations](../programming-guide/concepts/linq/type-relationships-in-linq-query-operations.md)  
 Describes how types are preserved and/or transformed in the three parts of a LINQ query operation  
  
 [Query syntax and method syntax in LINQ](../programming-guide/concepts/linq/query-syntax-and-method-syntax-in-linq.md)  
 Compares method syntax and query syntax as two ways to express a LINQ query.  
  
 [C# features that support LINQ](../programming-guide/concepts/linq/features-that-support-linq.md)  
 Describes the language constructs in C# that support LINQ.  
   
## Related sections  
 [LINQ query expressions](../programming-guide/linq-query-expressions/index.md)  
 Includes an overview of queries in LINQ and provides links to additional resources.  
  
 [Standard query operators overview](../programming-guide/concepts/linq/standard-query-operators-overview.md)  
 Introduces the standard methods used in LINQ.  
  