---
title: "Compiler Error CS0011 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "CS0011"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0011"
ms.assetid: 892553d7-a516-4631-84cd-94db5722c90d
caps.latest.revision: 18
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0011
The base class or interface 'class' in assembly 'assembly' referenced by type 'type' could not be resolved  
  
 A class that was imported from a file with **/reference**, is derived from a class or implements an interface that is not found. This can occur if a required DLL is not also included in the compilation with **/reference**.  
  
 For more information, see [Add Reference Dialog Box](http://msdn.microsoft.com/en-us/2feb0fe2-0805-4cc9-8cba-b0315849dfb7) and [/reference (C# Compiler Options)](../../csharp/language-reference/compiler-options/reference-compiler-option.md).  
  
## Example  
  
```  
// CS0011_1.cs  
// compile with: /target:library  
  
public class Outer   
{  
   public class B { }  
}  
```  
  
## Example  
 The second file creates a DLL that defines a class `C` that is derived from the class `B` that was created in the previous example.  
  
```  
// CS0011_2.cs  
// compile with: /target:library /reference:CS0011_1.dll  
// post-build command: del /f CS0011_1.dll  
public class C : Outer.B {}  
```  
  
## Example  
 The third file replaces the DLL created by the first step, and omits the definition of the inner class `B`.  
  
```  
// CS0011_3.cs  
// compile with: /target:library /out:cs0011_1.dll  
public class Outer {}  
```  
  
## Example  
 Finally, the fourth file references the class `C` defined in the second example, which is derived from class `B`, and which is now missing.  
  
 The following sample generates CS0011.  
  
```  
// CS0011_4.cs  
// compile with: /reference:CS0011_1.dll /reference:CS0011_2.dll  
// CS0011 expected  
  
class M  
{  
   public static void Main()  
   {  
      C c = new C();  
   }  
}  
```  
  
## See Also  
 [Add Reference Dialog Box](http://msdn.microsoft.com/en-us/2feb0fe2-0805-4cc9-8cba-b0315849dfb7)   
 [/reference (C# Compiler Options)](../../csharp/language-reference/compiler-options/reference-compiler-option.md)