---
title: "Compiler Error CS0172 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0172"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0172"
ms.assetid: 1272c575-3580-4897-95fb-83f45d7435ae
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0172
Type of conditional expression cannot be determined because 'type1' and 'type2' implicitly convert to one another  
  
 In a conditional statement, you must be able to convert the types on either side of the `:` operator. Also, there cannot be mutual conversion routines; you only need one conversion. For more information, see [Conversion Operators](../../csharp/programming-guide/statements-expressions-operators/conversion-operators.md).  
  
 The following sample generates CS0172:  
  
```  
// CS0172.cs  
public class Square  
{  
   public class Circle  
   {  
      public static implicit operator Circle(Square aa)  
      {  
         return null;  
      }  
  
      public static implicit operator Square(Circle aa)  
      // using explicit resolves this error  
      // public static explicit operator Square(Circle aa)  
      {  
         return null;  
      }  
   }  
  
   public static void Main()  
   {  
      Circle aa = new Circle();  
      Square ii = new Square();  
      object o = (1 == 1) ? aa : ii;   // CS0172  
      // the following cast would resolve this error  
      // (1 == 1) ? aa : (Circle)ii;  
   }  
}  
```