---
title: "Compiler Error CS0202 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0202"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0202"
ms.assetid: 7088850f-c206-4b95-9586-a0fa3d876c0c
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0202
foreach requires that the return type 'type' of 'type.GetEnumerator()' must have a suitable public MoveNext method and public Current property  
  
 A <xref:System.Collections.IEnumerable.GetEnumerator%2A> function, used to enable the use of foreach statements, cannot return a pointer or array; it must return an instance of a class that is able to act as an enumerator. The proper requirements to serve as an enumerator include a public Current property and a public MoveNext method.  
  
> [!NOTE]
>  In C# 2.0, the compiler will automatically generate Current and MoveNext for you. For more information, see the code example in [Generic Interfaces](../../csharp/programming-guide/generics/generic-interfaces.md).  
  
 The following sample generates CS0202:  
  
```  
// CS0202.cs  
  
public class C1  
{  
   public int Current  
   {  
      get  
      {  
         return 0;  
      }  
   }  
  
   public bool MoveNext ()  
   {  
      return false;  
   }  
  
   public static implicit operator C1 (int c1)  
   {  
      return 0;  
   }  
}  
  
public class C2  
{  
   public int Current  
   {  
      get  
      {  
         return 0;  
      }  
   }  
  
   public bool MoveNext ()  
   {  
      return false;  
   }  
  
   public C1[] GetEnumerator ()  
   // try the following line instead  
   // public C1 GetEnumerator ()  
   {  
      return null;  
   }  
}  
  
public class MainClass  
{  
   public static void Main ()  
   {  
      C2 c2 = new C2();  
  
      foreach (C1 x in c2)   // CS0202  
      {  
         System.Console.WriteLine(x.Current);  
      }  
   }  
}  
```