---
title: "Compiler Warning (level 2) CS0279 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0279"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0279"
ms.assetid: 5e5faa8f-3d5b-4999-aa62-ff7f131a3e04
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 2) CS0279
'type name' does not implement the 'pattern name' pattern. 'method name' is either static or not public.  
  
 There are several statements in C# that rely on defined patterns, such as `foreach` and `using`. For example, `foreach` relies on the collection class implementing the enumerable pattern. This error occurs when the compiler is unable to make the match due to a method being declared `static` or not `public`. Methods in patterns are required to be instances of classes, and to be public.  
  
## Example  
 The following example generates CS0279:  
  
```  
// CS0279.cs  
  
using System;  
using System.Collections;  
  
public class myTest : IEnumerable  
{  
    IEnumerator IEnumerable.GetEnumerator()  
    {  
        yield return 0;  
    }  
  
    internal IEnumerator GetEnumerator()  
    {  
        yield return 0;  
    }  
  
    public static void Main()  
    {  
        foreach (int i in new myTest()) {}  // CS0279  
    }  
}  
```