---
title: "Compiler Error CS0546 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0546"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0546"
ms.assetid: d259c86f-ee29-4e2d-b381-6ba7252af87e
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0546
'accessor' : cannot override because 'property' does not have an overridable set accessor  
  
 An attempt to override one of the accessor methods for a property failed because the accessor cannot be overridden. This error can occur if:  
  
-   the base class property is not declared as [virtual](../../csharp/language-reference/keywords/virtual.md).  
  
-   the base class property does not declare the [get](../../csharp/language-reference/keywords/get.md) or [set](../../csharp/language-reference/keywords/set.md) accessor you are trying to override.  
  
 If you do not want to override the base class property, you can use the [new](../../csharp/language-reference/keywords/new.md) keyword before the property in derived class.  
  
 For more information, see [Using Properties](../../csharp/programming-guide/classes-and-structs/using-properties.md).  
  
## Example  
 The following sample generates CS0546 because the base class does not declare a set accessor for the property.  
  
```  
// CS0546.cs  
// compile with: /target:library  
public class a  
{  
   public virtual int i  
   {  
      get  
      {  
         return 0;  
      }  
   }  
  
   public virtual int i2  
   {  
      get  
      {  
         return 0;  
      }  
  
      set {}  
   }  
}  
  
public class b : a  
{  
   public override int i  
   {  
      set {}   // CS0546 error no set  
   }  
  
   public override int i2  
   {  
      set {}   // OK  
   }  
}  
```  
  
## See Also  
 [Properties](../../csharp/programming-guide/classes-and-structs/properties.md)