---
title: "Compiler Error CS0762 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0762"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0762"
ms.assetid: 7cedd1af-ffe6-4ca7-82fb-faa9e98014a4
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0762
Cannot create delegate from method 'method' because it is a partial method without an implementing declaration  
  
 A partial method is not required to have an implementing declaration. However, a delegate does require that its encapsulated method have an implementation.  
  
## To correct this error  
  
1.  Provide an implementation for the method that is used to initialize the delegate.  
  
## Example  
  
```  
public delegate void TestDel();  
  
    public partial class C  
    {  
        partial void Part();  
  
        public static int Main()  
        {  
            C c = new C();  
            TestDel td = new TestDel(c.Part); // CS0762  
            return 1;  
        }  
  
    }  
```