---
title: "Compiler Error CS0819 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0819"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0819"
ms.assetid: a5369e03-eb7d-4c88-b390-51304bd8d1ae
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0819
Implicitly typed locals cannot have multiple declarators.  
  
 Multiple declarators are allowed in explicit type declarations, but not with implicitly typed variables.  
  
## To correct this error  
  
1.  Declare and assign a value to each implicitly typed local variable on a separate line.  
  
## Example  
 The following code generates CS0819:  
  
```  
// cs0819.cs  
class A  
{  
    public static int Main()  
    {  
        var a = 3, b = 2; // CS0819  
        return -1;  
    }  
}  
```  
  
## See Also  
 [Implicitly Typed Local Variables](../../csharp/programming-guide/classes-and-structs/implicitly-typed-local-variables.md)