---
title: "Compiler Error CS0842 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0842"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0842"
ms.assetid: 93a8b333-efc4-40c7-ae53-5264f721a74f
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0842
Automatically implemented properties cannot be used inside a type marked with StructLayout(LayoutKind.Explicit).  
  
 Auto-implemented properties have their backing fields provided by the compiler and the field is not accessible to source code. Therefore, they are not compatible with <xref:System.Runtime.InteropServices.LayoutKind?displayProperty=fullName>.  
  
## To correct this error  
  
1.  Make the property a regular property in which you provide the accessor bodies.  
  
## Example  
 The following example generates CS0842:  
  
```  
// cs0842.cs  
using System;  
using System.Runtime.InteropServices;  
  
namespace TestNamespace  
{  
    [StructLayout(LayoutKind.Explicit)]  
    struct Str  
    {  
        public int Num // CS0842  
        {  
            get;  
            set;  
        }  
  
        static int Main()  
        {  
            return 1;  
        }  
    }  
}  
```