---
title: "Compiler Warning (level 1) CS3006 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS3006"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS3006"
ms.assetid: efbfd898-e46f-4c3d-91e2-e2da0056b016
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS3006
Overloaded method 'method' differing only in ref or out, or in array rank, is not CLS-compliant  
  
 A method does not cannot be overloaded based on the [ref](../../csharp/language-reference/keywords/ref.md) or [out](../../csharp/language-reference/keywords/out.md) parameter and still comply with the Common Language Specification (CLS). For more information on CLS Compliance, see [Writing CLS-Compliant Code](http://msdn.microsoft.com/en-us/4c705105-69a2-4e5e-b24e-0633bc32c7f3) and [Language Independence and Language-Independent Components](https://msdn.microsoft.com/library/12a7a7h3).  
  
## Example  
 The following example generates CS3006. To resolve this warning, comment out the assembly-level attribute or remove one of the method definitions.  
  
```  
// CS3006.cs  
  
using System;  
  
[assembly: CLSCompliant(true)]  
public class MyClass  
{  
    public void f(int i)  
    {  
    }  
  
    public void f(ref int i)   // CS3006  
    {  
    }  
  
    public static void Main()  
    {  
    }  
}  
```