---
title: "Explicit initialization is not permitted for arrays declared with explicit bounds | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc30672"
  - "vbc30672"
helpviewer_keywords: 
  - "BC30672"
ms.assetid: 4b525e8d-bde5-4408-8c10-7605ca039f0e
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Explicit initialization is not permitted for arrays declared with explicit bounds
Arrays cannot be initialized if they are declared to be a specific size.  
  
 **Error ID:** BC30672  
  
## To correct this error  
  
-   Declare the array, and then initialize it separately.  
  
-   Declare and initialize as a dynamic array, and use `ReDim` if necessary; for example:  
  
    ```  
    Dim A() As Integer = {0, 1, 2, 3}  
    ReDim Preserve A(3)  
    ```  
  
## See Also  
 [Arrays](../../visual-basic/programming-guide/language-features/arrays/index.md)