---
title: "Specified access &#39;&lt;accesslevel1&gt;&#39; for &#39;&lt;partialtypename&gt;&#39; does not match the access &#39;&lt;accesslevel2&gt;&#39; specified on one of its other partial types | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30925"
  - "BC30925"
helpviewer_keywords: 
  - "BC30925"
ms.assetid: aabe0f4a-dc02-4828-a837-20cd47a7bd43
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Specified access &#39;&lt;accesslevel1&gt;&#39; for &#39;&lt;partialtypename&gt;&#39; does not match the access &#39;&lt;accesslevel2&gt;&#39; specified on one of its other partial types
A class or structure is defined in multiple partial declarations with conflicting access level specifications.  
  
 When you divide the definition of a class or structure among several partial declarations, the compiler treats the type as the union of all its partial declarations. This applies not only to the members but also to the implementation, inheritance, and access level.  
  
 You cannot mix access levels in the definition of a class or structure. Even the combination `Protected Friend` is allowed only when the keywords are contiguous in the same declaration statement.  
  
 **Error ID:** BC30925  
  
## To correct this error  
  
-   Decide what the access level of the class should be, and remove any conflicting access level specifications.  
  
## See Also  
 [Partial](../../visual-basic/language-reference/modifiers/partial.md)   
 [Access Levels in Visual Basic](../../visual-basic/programming-guide/language-features/declared-elements/access-levels.md)   
 [Class Statement](../../visual-basic/language-reference/statements/class-statement.md)   
 [Structure Statement](../../visual-basic/language-reference/statements/structure-statement.md)   
 [NOT IN BUILD: Classes: Blueprints for Objects](http://msdn.microsoft.com/en-us/2c86373d-0333-4616-a7d8-4790c4e89f7b)   
 [Structures](../../visual-basic/programming-guide/language-features/data-types/structures.md)