---
title: "Method &#39;&lt;methodname1&gt;&#39; cannot implement partial method &#39;&lt;methodname2&gt;&#39; because &#39;&lt;methodname3&gt;&#39; already implements it | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc31434"
  - "bc31434"
helpviewer_keywords: 
  - "BC31434"
ms.assetid: 61cba19e-db11-4a06-89d6-4244d411588c
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Method &#39;&lt;methodname1&gt;&#39; cannot implement partial method &#39;&lt;methodname2&gt;&#39; because &#39;&lt;methodname3&gt;&#39; already implements it
Method '\<methodname1>' cannot implement partial method '\<methodname2>' because '\<methodname3>' already implements it. Only one method can implement a partial method.  
  
 You cannot have two partial methods that implement the same partial method declaration. The following code causes this error.  
  
```vb  
Partial Class Product  
  
    ' Declaration of the partial method.  
    Partial Private Sub ValueChanged()  
    End Sub  
  
End Class  
```  
  
```vb  
Partial Class Product  
  
    ' First implementation of the partial method.  
    Private Sub ValueChanged()  
        MsgBox(Value was changed to " & Me.Quantity)  
    End Sub  
  
    ' Second implementation of the partial method causes this error.  
    'Private Sub ValueChanged()  
    '    Console.WriteLine("Quantity was changed to " & Me.Quantity)  
    'End Sub  
  
End Class  
```  
  
 **Error ID:** BC31434  
  
## See Also  
 [Partial Methods](../../visual-basic/programming-guide/language-features/procedures/partial-methods.md)