---
title: "Option Strict On disallows operands of type Object for operator &#39;&lt;operatorname&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32013"
  - "vbc32013"
helpviewer_keywords: 
  - "BC32013"
ms.assetid: cd197da8-2676-453b-884b-3231fb6f909d
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Option Strict On disallows operands of type Object for operator &#39;&lt;operatorname&gt;&#39;
Option Strict On disallows operands of type Object for operator '\<operatorname>'. Use the Is operator to test for object identity.  
  
 An arithmetic comparison operator such as `=` is used with one or more object variables when `Option Strict` is `On`.  
  
 **Error ID:** BC32013  
  
## To correct this error  
  
1.  Turn `Option Strict Off` if the object variables contain numeric values and you intend an arithmetic comparison.  
  
2.  Use the `Is` operator to compare for object identity.  
  
## See Also  
 [Comparison Operators](../../visual-basic/language-reference/operators/comparison-operators.md)   
 [Is Operator](../../visual-basic/language-reference/operators/is-operator.md)   
 [Option Strict Statement](../../visual-basic/language-reference/statements/option-strict-statement.md)