---
title: "&#39;Assembly&#39; or &#39;Module&#39; expected | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc32015"
  - "bc32015"
helpviewer_keywords: 
  - "BC32015"
ms.assetid: 6e62fe8d-a875-4995-b6b2-443e75c65e85
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Assembly&#39; or &#39;Module&#39; expected
A global attribute is specified without indicating whether it applies to the entire assembly or only to the current module. Global attributes must specify either `Assembly` or `Module`.  
  
 A global attribute is one that appears on a source line by itself, rather than being applied to the declaration of a particular programming element.  
  
 **Error ID:** BC32015  
  
## To correct this error  
  
1.  If you intend the attribute to be global, add the `Assembly` or `Module` keyword to the beginning of the attribute block, followed by a colon (:).  
  
2.  If you do not intend the attribute to be global, delete the attribute block or move it to a programming element declaration.  
  
## See Also  
 [Assembly](../../visual-basic/language-reference/modifiers/assembly.md)   
 [Module \<keyword>](../../visual-basic/language-reference/modifiers/module-keyword.md)   
 [NOT IN BUILD: Application of Attributes](http://msdn.microsoft.com/en-us/2b1703ed-4437-49b3-bc0b-568094324f47)   
 [NOT IN BUILD: Global Attributes in Visual Basic](http://msdn.microsoft.com/en-us/253a32d8-1531-4504-b687-088554ab71d2)