---
title: "&#39;&lt;typename&gt;&#39; is a generic type and requires type arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC32076"
  - "vbc32076"
helpviewer_keywords: 
  - "BC32076"
ms.assetid: 57f63727-c544-4012-8f03-5d77fbdd1135
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;&lt;typename&gt;&#39; is a generic type and requires type arguments
A variable, procedure parameter, or function return is declared to have the type of a generic class or structure, but the declaration does not supply any type arguments.  
  
 By its nature, every generic class and structure is defined with at least one type parameter. When you use a generic type to declare a constructed class or structure, you must supply a type argument for every type parameter defined by the generic type.  
  
 **Error ID:** BC32076  
  
## To correct this error  
  
-   Add a type list to the declaration, enclosed in parentheses and beginning with the `Of` keyword.  
  
## See Also  
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Of](../../visual-basic/language-reference/statements/of-clause.md)   
 [Type List](../../visual-basic/language-reference/statements/type-list.md)