---
title: "Type argument inference failed for type parameter &#39;&lt;typeparametername1&gt;&#39; of &#39;&lt;genericproceduresignature&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc32116"
  - "bc32116"
helpviewer_keywords: 
  - "BC32116"
ms.assetid: 6bfb02ec-814a-4b1f-a585-6d902a861d00
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Type argument inference failed for type parameter &#39;&lt;typeparametername1&gt;&#39; of &#39;&lt;genericproceduresignature&gt;&#39;
Type argument inference failed for type parameter '\<typeparametername1>' of '\<genericproceduresignature>'. Type argument inferred from the argument passed to parameter '\<parametername1>' conflicts with the type argument inferred from the argument passed to parameter '\<parametername2>'.  
  
 A generic procedure is called without any type arguments, and the attempted type inference has produced a data type conflict among the type parameters.  
  
 Normally, when you call a generic procedure, you supply a type argument for each type parameter that the generic procedure defines. If you do not supply any type arguments, then the compiler attempts to infer the types to be passed to the type parameters. If the context of the call provides conflicting data type information for a type parameter, then the type inference fails.  
  
 The following code can generate this error.  
  
```  
Public Sub takeTwoValues(Of t)(ByVal x As t, ByVal y As t)  
End Sub  
Call takeTwoValues(4, 2.5)  
```  
  
 Because the first argument causes the compiler to infer `Integer` for type parameter `t`, while the second argument causes it to infer `Double` for the same type parameter, there is a conflict regarding which data type to pass to `t`.  
  
 **Error ID:** BC32116  
  
## To correct this error  
  
-   Supply type arguments to the generic type, so that the compiler does not have to infer them.  
  
    ```  
    Call takeTwoValues(Of Double)(4, 2.5)  
    ```  
  
     Notice that in this case, where the two normal arguments are of different data types, the calling code must pass a type argument that can accommodate both of those data types. In this case, `Integer` widens to `Double`.  
  
     -or-  
  
-   Redefine the generic procedure to specify different type parameters for the normal parameters, so that there is no conflict inferring the types.  
  
    ```  
    Public Sub takeTwoValues(Of t1, t2)(ByVal x As t1, ByVal y As t2)  
    ```  
  
## See Also  
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Generic Procedures in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-procedures.md)   
 [Type List](../../visual-basic/language-reference/statements/type-list.md)