---
title: "Cannot inherit interface &#39;&lt;interfacename1&gt;&#39; because the interface &#39;&lt;interfacename2&gt;&#39; from which it inherits could be identical to interface &#39;&lt;interfacename3&gt;&#39; for some type arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32121"
  - "vbc32121"
helpviewer_keywords: 
  - "BC32121"
ms.assetid: 56b1167e-f626-4a27-8395-9d396cc209f2
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Cannot inherit interface &#39;&lt;interfacename1&gt;&#39; because the interface &#39;&lt;interfacename2&gt;&#39; from which it inherits could be identical to interface &#39;&lt;interfacename3&gt;&#39; for some type arguments
A generic interface inherits from two or more generic interfaces, and two of the inheritances could conflict for certain values of type arguments.  
  
 The following statements can generate this error.  
  
```  
Public Interface interfaceA(Of u)  
    Inherits interfaceX(Of u)  
End Interface  
Public Interface interfaceX(Of v)  
End Interface  
Public Interface derivedInterface(Of t1, t2)  
    Inherits interfaceA(Of t1), interfaceX(Of t2)  
End Interface  
```  
  
 If `derivedInterface` is constructed or implemented supplying the same type to both `t1` and `t2`, it must inherit two versions of `interfaceX` with identical type arguments. Doing so would produce an ambiguity about which version to access.  
  
 **Error ID:** BC32121  
  
## To correct this error  
  
-   Change one of the type arguments supplied to the derived interface so that there is no conflict.  
  
     -or-  
  
-   Remove from the `Inherits` statement one of the interfaces causing the potential inheritance or implementation conflict.  
  
## See Also  
 [NOT IN BUILD: Interfaces Overview](http://msdn.microsoft.com/en-us/f96bb470-c1b8-4c73-89bc-6f536b798da1)   
 [Interface Statement](../../visual-basic/language-reference/statements/interface-statement.md)   
 [Inheritance Basics](../../visual-basic/programming-guide/language-features/objects-and-classes/inheritance-basics.md)   
 [Inherits Statement](../../visual-basic/language-reference/statements/inherits-statement.md)   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)