---
title: "Illegal call expression or index expression | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc32303"
  - "bc32303"
helpviewer_keywords: 
  - "BC32303"
ms.assetid: eed6a16e-4a44-4f72-b1de-d4212940da37
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Illegal call expression or index expression
A value in parentheses follows an expression that is not a procedure, property, or array.  
  
 The following code can generate this error.  
  
 `Dim testVariable As Object = Nothing(1)`  
  
 Because `Nothing` does not take arguments or indexes, you cannot use it with parentheses.  
  
 **Error ID:** BC32303  
  
## To correct this error  
  
-   Remove the parentheses and any value they contain.  
  
## See Also  
 [How to: Call a Procedure That Returns a Value](../../visual-basic/programming-guide/language-features/procedures/how-to-call-a-procedure-that-returns-a-value.md)   
 [How to: Call a Procedure that Does Not Return a Value](../../visual-basic/programming-guide/language-features/procedures/how-to-call-a-procedure-that-does-not-return-a-value.md)   
 [NOTINBUILD How to: Put a Value into an Array](http://msdn.microsoft.com/en-us/6dddc79c-cf60-41c2-b572-8bfa49b4fe7e)   
 [NOTINBUILD How to: Get a Value from an Array](http://msdn.microsoft.com/en-us/202a6468-8ccb-4864-bd8b-eab3b42d4288)   
 [How to: Put a Value in a Property](../../visual-basic/programming-guide/language-features/procedures/how-to-put-a-value-in-a-property.md)   
 [How to: Get a Value from a Property](../../visual-basic/programming-guide/language-features/procedures/how-to-get-a-value-from-a-property.md)