---
title: "&#39;Microsoft.VisualBasic.ComClassAttribute&#39; cannot be applied to a class that is declared &#39;MustInherit&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC32508"
  - "vbc32508"
helpviewer_keywords: 
  - "BC32508"
ms.assetid: c8af606d-f448-4703-98df-e594fd511f92
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Microsoft.VisualBasic.ComClassAttribute&#39; cannot be applied to a class that is declared &#39;MustInherit&#39;
A class is declared with the <xref:Microsoft.VisualBasic.ComClassAttribute>, but its declaration specifies `MustInherit`.  
  
 To be eligible for COM interop, a .NET Framework class must satisfy the following requirements:  
  
-   It must be `Public`, all its containers must be `Public`, and it must expose at least one `Public` member.  
  
-   It must not be *abstract*, that is, it must not be declared with `MustInherit`.  
  
-   It must not be generic or be declared within a generic container type.  
  
 **Error ID:** BC32508  
  
## To correct this error  
  
-   Remove the `MustInherit` keyword from the class declaration.  
  
     -or-  
  
-   If the class or its containing element must be generic, remove the <xref:Microsoft.VisualBasic.ComClassAttribute> from the class declaration. You cannot expose it to COM.  
  
## See Also  
 <xref:Microsoft.VisualBasic.ComClassAttribute>   
 [COM Interop](../../visual-basic/programming-guide/com-interop/index.md)   
 [MustInherit](../../visual-basic/language-reference/modifiers/mustinherit.md)