---
title: "Parameter type of this unary operator must be the containing type &#39;&lt;typename&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33020"
  - "bc33020"
helpviewer_keywords: 
  - "BC33020"
ms.assetid: 9c2c2c5b-6f18-49d2-bd6e-e735a6bced77
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Parameter type of this unary operator must be the containing type &#39;&lt;typename&gt;&#39;
A definition of a unary operator specifies a parameter with a type other than that of the class or structure in which the operator is defined.  
  
 When you define an operator in a class or structure, at least one of the parameters must be of the type of that class or structure. In the case of a unary operator, the sole operand must be of the type of that class or structure.  
  
 **Error ID:** BC33020  
  
## To correct this error  
  
-   Change the parameter type to the type of the class or structure in which the operator is defined.  
  
-   If you want to take one data type as a parameter and return a different data type as the result of the operation, define a conversion operator instead.  
  
## See Also  
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)   
 [How to: Define an Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-an-operator.md)   
 [How to: Define a Conversion Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-a-conversion-operator.md)