---
title: "&#39;And&#39; expected | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36620"
  - "bc36620"
helpviewer_keywords: 
  - "BC36620"
ms.assetid: b3d21d4d-86c0-44d2-8afc-c19d375e9ddd
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;And&#39; expected
A comparison operator other than `And` has been used to combine two or more `Equals` operators in a `Join` or `Group Join` clause. Only the `And` operator is allowed to combine multiple `Equals` operators in a `Join` or `Group Join` clause.  
  
 **Error ID:** BC36620  
  
## To correct this error  
  
1.  Restructure the `Equals` clauses to make comparisons by using only the `And` operator. The following is an example:  
  
```vb  
Dim petOwnersJoin = From pers In people _  
                    Join pet In pets _  
                    On pet.Owner Equals pers And _  
                       pet.Name = pers.PetName_  
                    Select pers, pet  
```  
  
## See Also  
 [How to: Combine Data with Joins](../../visual-basic/programming-guide/language-features/linq/how-to-combine-data-with-linq-by-using-joins.md)   
 [Join Clause](../../visual-basic/language-reference/queries/join-clause.md)   
 [Group Join Clause](../../visual-basic/language-reference/queries/group-join-clause.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)