---
title: "Inappropriate use of &lt;keyword&gt; keyword in a module | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc42028"
  - "BC42028"
helpviewer_keywords: 
  - "BC42028"
ms.assetid: a9bc1e9d-ba2c-4a71-b147-0fb66f670316
caps.latest.revision: 12
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Inappropriate use of &lt;keyword&gt; keyword in a module
Modules do not have instances, support inheritance, or implement interfaces. Therefore, the following keywords do not apply to a module declaration:  
  
-   [MustInherit](../../visual-basic/language-reference/modifiers/mustinherit.md)  
  
-   [NotInheritable](../../visual-basic/language-reference/modifiers/notinheritable.md)  
  
-   [Overloads](../../visual-basic/language-reference/modifiers/overloads.md)  
  
-   [Private](../../visual-basic/language-reference/modifiers/private.md)  
  
-   [Protected](../../visual-basic/language-reference/modifiers/protected.md)  
  
-   [Shadows](../../visual-basic/language-reference/modifiers/shadows.md)  
  
-   [Shared](../../visual-basic/language-reference/modifiers/shared.md)  
  
-   [Static](../../visual-basic/language-reference/modifiers/static.md)  
  
 The only keywords supported in a [Module Statement](../../visual-basic/language-reference/statements/module-statement.md) are [Public](../../visual-basic/language-reference/modifiers/public.md) and [Friend](../../visual-basic/language-reference/modifiers/friend.md).  
  
 In addition, you cannot use the [Implements](../../visual-basic/language-reference/statements/implements-clause.md) statement or the [Inherits Statement](../../visual-basic/language-reference/statements/inherits-statement.md) in the statement block of the module.  
  
 By default, this message is a warning. For more information about how to hide warnings or treat warnings as errors, see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC42028  
  
## To correct this error  
  
-   If you intend this programming element to be a module, use only the `Public` or `Friend` keyword in its declaration. By default, a module uses to `Friend` if you do not specify its access level.  
  
-   If you intend to create instances of this programming element, declare it as a class. You can then use the keywords that apply to a class declaration.  
  
## See Also  
 [Class Statement](../../visual-basic/language-reference/statements/class-statement.md)