declare module 'stripe' {
  namespace Stripe {
    /**
     * The TaxRate object.
     */
    interface TaxRate {
      /**
       * Unique identifier for the object.
       */
      id: string;

      /**
       * String representing the object's type. Objects of the same type share the same value.
       */
      object: 'tax_rate';

      /**
       * Defaults to `true`. When set to `false`, this tax rate cannot be applied to objects in the API, but will still be applied to subscriptions and invoices that already have it set.
       */
      active: boolean;

      /**
       * Time at which the object was created. Measured in seconds since the Unix epoch.
       */
      created: number;

      /**
       * An arbitrary string attached to the tax rate for your internal use only. It will not be visible to your customers.
       */
      description: string | null;

      /**
       * The display name of the tax rates as it will appear to your customer on their receipt email, PDF, and the hosted invoice page.
       */
      display_name: string;

      /**
       * This specifies if the tax rate is inclusive or exclusive.
       */
      inclusive: boolean;

      /**
       * The jurisdiction for the tax rate.
       */
      jurisdiction: string | null;

      /**
       * Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
       */
      livemode: boolean;

      /**
       * Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
       */
      metadata: Metadata;

      /**
       * This represents the tax rate percent out of 100.
       */
      percentage: number;
    }

    interface TaxRateCreateParams {
      /**
       * The display name of the tax rate, which will be shown to users.
       */
      display_name: string;

      /**
       * This specifies if the tax rate is inclusive or exclusive.
       */
      inclusive: boolean;

      /**
       * This represents the tax rate percent out of 100.
       */
      percentage: number;

      /**
       * Flag determining whether the tax rate is active or inactive. Inactive tax rates continue to work where they are currently applied however they cannot be used for new applications.
       */
      active?: boolean;

      /**
       * An arbitrary string attached to the tax rate for your internal use only. It will not be visible to your customers.
       */
      description?: string;

      /**
       * Specifies which fields in the response should be expanded.
       */
      expand?: Array<string>;

      /**
       * The jurisdiction for the tax rate.
       */
      jurisdiction?: string;

      /**
       * Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
       */
      metadata?: MetadataParam;
    }

    interface TaxRateRetrieveParams {
      /**
       * Specifies which fields in the response should be expanded.
       */
      expand?: Array<string>;
    }

    interface TaxRateUpdateParams {
      /**
       * Flag determining whether the tax rate is active or inactive. Inactive tax rates continue to work where they are currently applied however they cannot be used for new applications.
       */
      active?: boolean;

      /**
       * An arbitrary string attached to the tax rate for your internal use only. It will not be visible to your customers.
       */
      description?: string;

      /**
       * The display name of the tax rate, which will be shown to users.
       */
      display_name?: string;

      /**
       * Specifies which fields in the response should be expanded.
       */
      expand?: Array<string>;

      /**
       * The jurisdiction for the tax rate.
       */
      jurisdiction?: string;

      /**
       * Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
       */
      metadata?: MetadataParam | null;
    }

    interface TaxRateListParams extends PaginationParams {
      /**
       * Optional flag to filter by tax rates that are either active or not active (archived)
       */
      active?: boolean;

      /**
       * Optional range for filtering created date
       */
      created?: RangeQueryParam | number;

      /**
       * Specifies which fields in the response should be expanded.
       */
      expand?: Array<string>;

      /**
       * Optional flag to filter by tax rates that are inclusive (or those that are not inclusive)
       */
      inclusive?: boolean;

      /**
       * Optional range for tax rate percentage filtering
       */
      percentage?: RangeQueryParam | number;
    }

    class TaxRatesResource {
      /**
       * Creates a new tax rate.
       */
      create(
        params: TaxRateCreateParams,
        options?: RequestOptions
      ): Promise<Stripe.TaxRate>;

      /**
       * Retrieves a tax rate with the given ID
       */
      retrieve(
        id: string,
        params?: TaxRateRetrieveParams,
        options?: RequestOptions
      ): Promise<Stripe.TaxRate>;
      retrieve(id: string, options?: RequestOptions): Promise<Stripe.TaxRate>;

      /**
       * Updates an existing tax rate.
       */
      update(
        id: string,
        params?: TaxRateUpdateParams,
        options?: RequestOptions
      ): Promise<Stripe.TaxRate>;

      /**
       * Returns a list of your tax rates. Tax rates are returned sorted by creation date, with the most recently created tax rates appearing first.
       */
      list(
        params?: TaxRateListParams,
        options?: RequestOptions
      ): ApiListPromise<Stripe.TaxRate>;
      list(options?: RequestOptions): ApiListPromise<Stripe.TaxRate>;
    }
  }
}
