#### Fix incorrectly wrapped arrow functions with return types (#10940 by @thorn0)

<!-- prettier-ignore -->
```ts
// Input
longfunctionWithCall12("bla", foo, (thing: string): complex<type<something>> => {
  code();
});

// Prettier stable
longfunctionWithCall12("bla", foo, (thing: string): complex<
  type<something>
> => {
  code();
});

// Prettier main
longfunctionWithCall12(
  "bla",
  foo,
  (thing: string): complex<type<something>> => {
    code();
  }
);
```
