#### Don't switch to explicit mappings needlessly (#10874 by @pdavies)

Previously, Prettier printed long YAML keys using explicit mapping syntax. The intent was to use that syntax to accommodate multiline keys, but it had the unintended effect of using it even for long keys that couldn’t be made multiline – for example, because `--prose-wrap` was set to `preserve` or the key didn’t contain whitespace. This is bad because:

- Doing so has the effect of further increasing the line length.
- Explicit mappings are obscure and most people have never seen them. It causes confusion to introduce them needlessly.

<!-- prettier-ignore -->
```yaml
# Input
- stage: Process
  jobs:
    - template: Process.yml
      parameters:
        ${{ if in(parameters.BuildType, 'a') }}:
          BuildArtifacts:
            - input: Build.Release.x86
              output: Processed.Release.x86
        ${{ if in(parameters.BuildType, 'b                                 ') }}:
          BuildArtifacts:
            - input: Build.Release
              output: Processed.Release

# Prettier stable
- stage: Process
  jobs:
    - template: Process.yml
      parameters:
        ${{ if in(parameters.BuildType, 'a') }}:
          BuildArtifacts:
            - input: Build.Release.x86
              output: Processed.Release.x86
        ? ${{ if in(parameters.BuildType, 'b                                 ') }}
        : BuildArtifacts:
            - input: Build.Release
              output: Processed.Release

# Prettier main
- stage: Process
  jobs:
    - template: Process.yml
      parameters:
        ${{ if in(parameters.BuildType, 'a') }}:
          BuildArtifacts:
            - input: Build.Release.x86
              output: Processed.Release.x86
        ${{ if in(parameters.BuildType, 'b                                 ') }}:
          BuildArtifacts:
            - input: Build.Release
              output: Processed.Release

# Prettier main (with --prose-wrap always)
- stage: Process
  jobs:
    - template: Process.yml
      parameters:
        ${{ if in(parameters.BuildType, 'a') }}:
          BuildArtifacts:
            - input: Build.Release.x86
              output: Processed.Release.x86
        ? ${{ if in(parameters.BuildType, 'b                                 ')
          }}
        : BuildArtifacts:
            - input: Build.Release
              output: Processed.Release
```
