---
id: ignore
title: Ignoring Code
---

Use `.prettierignore` to ignore (i.e. not reformat) certain files and folders completely.

Use “prettier-ignore” comments to ignore parts of files.

## Ignoring Files: .prettierignore

To exclude files from formatting, create a `.prettierignore` file in the root of your project. `.prettierignore` uses [gitignore syntax](https://git-scm.com/docs/gitignore#_pattern_format).

Example:

```
# Ignore artifacts:
build
coverage

# Ignore all HTML files:
*.html
```

It’s recommended to have a `.prettierignore` in your project! This way you can run `prettier --write .` to make sure that everything is formatted (without mangling files you don’t want, or choking on generated files). And – your editor will know which files _not_ to format!

(See also the [`--ignore-path` CLI option](cli.md#--ignore-path).)

## JavaScript

A JavaScript comment of `// prettier-ignore` will exclude the next node in the abstract syntax tree from formatting.

For example:

<!-- prettier-ignore -->
```js
matrix(
  1, 0, 0,
  0, 1, 0,
  0, 0, 1
)

// prettier-ignore
matrix(
  1, 0, 0,
  0, 1, 0,
  0, 0, 1
)
```

will be transformed to:

```js
matrix(1, 0, 0, 0, 1, 0, 0, 0, 1);

// prettier-ignore
matrix(
  1, 0, 0,
  0, 1, 0,
  0, 0, 1
)
```

## JSX

```jsx
<div>
  {/* prettier-ignore */}
  <span     ugly  format=''   />
</div>
```

## HTML

```html
<!-- prettier-ignore -->
<div         class="x"       >hello world</div            >

<!-- prettier-ignore-attribute -->
<div
  (mousedown)="       onStart    (    )         "
  (mouseup)="         onEnd      (    )         "
></div>

<!-- prettier-ignore-attribute (mouseup) -->
<div
  (mousedown)="onStart()"
  (mouseup)="         onEnd      (    )         "
></div>
```

## CSS

```css
/* prettier-ignore */
.my    ugly rule
{

}
```

## Markdown

```markdown
<!-- prettier-ignore -->
Do   not    format   this
```

### Range Ignore

_available in v1.12.0+_

This type of ignore is only allowed to be used in top-level and aimed to disable formatting for auto-generated content, e.g. [`all-contributors`](https://github.com/kentcdodds/all-contributors), [`markdown-toc`](https://github.com/jonschlinkert/markdown-toc), etc.

```markdown
<!-- prettier-ignore-start -->
<!-- SOMETHING AUTO-GENERATED BY TOOLS - START -->

| MY | AWESOME | AUTO-GENERATED | TABLE |
|-|-|-|-|
| a | b | c | d |

<!-- SOMETHING AUTO-GENERATED BY TOOLS - END -->
<!-- prettier-ignore-end -->
```

## YAML

To ignore a part of a YAML file, `# prettier-ignore` should be placed on the line immediately above the ignored node:

```yaml
# prettier-ignore
key  : value
hello: world
```

## GraphQL

```graphql
{
  # prettier-ignore
  addReaction(input:{superLongInputFieldName:"MDU6SXNzdWUyMzEzOTE1NTE=",content:HOORAY}) {
    reaction {content}
  }
}
```

## Handlebars

<!-- prettier-ignore -->
```hbs
{{! prettier-ignore }}
<div>
  "hello! my parent was ignored"
  {{#my-crazy-component     "shall"     be="preserved"}}
    <This
      is  =  "also preserved as is"
    />
  {{/my-crazy-component}}
</div>
```

## Command Line File Patterns

For one-off commands, when you want to exclude some files without adding them to `.prettierignore`, negative patterns can come in handy:

```bash
prettier --write . '!**/*.{js,jsx,vue}'
```

See [fast-glob](https://prettier.io/docs/en/cli.html#file-patterns) to learn more about advanced glob syntax.
