"use strict";

const prettier = require("prettier-local");
const concat = prettier.doc.builders.concat;

module.exports = {
  languages: [
    {
      name: "foobar",
      parsers: ["foobar"],
      extensions: [".foobar"]
    }
  ],
  parsers: {
    foobar: {
      parse: text => ({ text }),
      astFormat: "foobar"
    }
  },
  printers: {
    foobar: {
      print: path => concat(["foobar+", path.getValue().text])
    }
  }
};
