"use strict";

const prettier = require("prettier-local");
const concat = prettier.doc.builders.concat;

module.exports = {
  languages: [
    {
      name: "bespoke",
      parsers: ["bespoke"]
    }
  ],
  parsers: {
    bespoke: {
      parse: text => ({ text }),
      astFormat: "bespoke"
    }
  },
  printers: {
    bespoke: {
      print: path => concat(["bespoke+", path.getValue().text])
    }
  }
};
