---
author: @suchipi
authorURL: https://twitter.com/suchipi
title: "Prettier 1.7: JSX tweaks, Pragma, TypeScript and CSS fixes"
---

This release features some bugfixes and tweaks around JSX, TypeScript, CSS, and JavaScript formatting, as well as a couple new features.

<!--truncate-->

## Highlights

### JSX Changes

We received a lot of community feedback about the changes we made to JSX formatting in the 1.6.0 release, and have made changes to bring formatting closer to community standards and expectations.

In 1.6.0, we added a second style for ternaries (conditional expressions, `a ? b : c`), based on a format popular in the community where parentheses are used to demarcate JSX content:

<!-- prettier-ignore -->
```jsx
const DinnerOptions = ({ willEatMeat, willEatEggs, willEatVegetables }) => (
  <div>
    <div>Let's get some dinner...</div>
    {willEatMeat ? (
      <FullMenu />
    ) : willEatEggs ? (
      <VegetarianMenu />
    ) : willEatVegetables ? (
      <VeganMenu />
    ) : (
      <BackupMenu />
    )}
  </div>
);
```

Before this was added, prettier only formatted ternaries with one consistent style:

<!-- prettier-ignore -->
```jsx
willEatMeat
  ? "Full Menu"
  : willEatEggs
    ? "Vegetarian Menu"
    : willEatVegetables ? "Vegan Menu" : "Backup Menu";
```

In 1.6.0, we used the following heuristic to decide when to use the new "JSX mode ternaries":

```
We should print a ternary using JSX mode if:
  * The ternary contains some JSX in it
  OR
  * The ternary appears inside of some JSX
```

However, this heuristic caused some [unexpected formatting](https://github.com/prettier/prettier/issues/2729):
![GitHub Diff showing a ternary containing internationalization strings appearing inside a JSX element being converted to use JSX-mode style ternaries](/blog/assets/github-diff-ternary-in-jsx.png)

So, in 1.7.0, we have revised our heuristic to just be:

```
We should print a ternary using JSX mode if:
  * The ternary contains some JSX in it
```

We hope that this change will result in fewer surprising ternaries.

A big thanks goes out to [@duailibe](https://github.com/duailibe) who implemented this change in addition to several other JSX-related formatting issues that were reported.

### CSS Letter Case Consistency

We spent some time this release polishing our CSS formatting, and as part of that, [@lydell](https://github.com/lydell) [did some work to normalize letter case](https://github.com/prettier/prettier/issues/2653).

So now, almost everything in CSS will print using `lower case`.

<!-- prettier-ignore -->
```css
/* Before */
DIV.Foo {
  HEIGHT: 12PX;
}

/* After */
div.Foo {
  height: 12px;
}
```

Don't worry, though – Prettier won't touch your `$scss-variables`, `[@less](https://github.com/less)-variables`, or `FunctionNames()`. Preprocess on!

### Pragma Support

There is a new option called `--require-pragma` (`requirePragma` via the API) which will change prettier's behavior so that it only reformats a file if it has a special "pragma" comment at the top of it, that looks like this:

<!-- prettier-ignore -->
```js
/**
 * @prettier
 */
```

or

<!-- prettier-ignore -->
```js
/**
 * @format
 */
```

This was [@ajhyndman](https://github.com/ajhyndman)'s idea and it was implemented by [@wbinnssmith](https://github.com/wbinnssmith).

## Other Changes

### TypeScript

There was a bug in Prettier 1.6.1 where an error would be thrown while parsing any TypeScript using the `never` type, for example:

```ts
Observable.empty<never>();
```

Also, Prettier 1.6.1 was incorrectly removing the `declare` keyword from `enum` declarations in `*.d.ts` files:

<!-- prettier-ignore -->
```ts
// In
declare const enum Foo {}

// Out
const enum Foo {}
```

Both of these issues have been fixed. Thanks to [@JamesHenry](https://github.com/JamesHenry) and [@existentialism](https://github.com/existentialism) for these fixes which support our TypeScript community!

### Configuration

#### Configurable Config Precedence

There is a new CLI option `--config-precedence` which configures how prettier should prioritize config sources. Valid values are:

**`cli-override`** (default) - CLI options take precedence over config file

**`file-override`** - Config file take precedence over CLI options

**`prefer-file`** - If a config file is found will evaluate it and ignore other CLI options. If no config file is found CLI options will evaluate as normal.

This option adds support to editor integrations where users define their default configuration but want to respect project specific configuration.

#### `prettier.resolveConfig.sync`

Previously, there was no way via the API to resolve configuration for a source file synchronously. Thanks to [some new additions to `cosmiconfig`](https://github.com/davidtheclark/cosmiconfig/pull/78) by [@sudo](https://github.com/sudo)-suhas, [@ikatyang](https://github.com/ikatyang) was able to add support for this to the prettier API.

### PRs merged in this release

- [**Update README.md**](https://github.com/prettier/prettier/pull/2690) by [@ikatyang](https://github.com/ikatyang)
- [**Fix config file finding when using stdin**](https://github.com/prettier/prettier/pull/2692) by [@lydell](https://github.com/lydell)
- [**docs(readme): add and sort cli options**](https://github.com/prettier/prettier/pull/2700) by [@levithomason](https://github.com/levithomason)
- [**Add Transloadit as a user**](https://github.com/prettier/prettier/pull/2706) by [@kvz](https://github.com/kvz)
- [**Ensure parens around LogicalExpression inside ExperimentalSpreadProperty**](https://github.com/prettier/prettier/pull/2710) by [@existentialism](https://github.com/existentialism)
- [**Fix printing declare modifier for TS enum**](https://github.com/prettier/prettier/pull/2711) by [@existentialism](https://github.com/existentialism)
- [**Handle +/- before numbers in CSS**](https://github.com/prettier/prettier/pull/2713) by [@xtian](https://github.com/xtian)
- [**Add Tradeshift as a user**](https://github.com/prettier/prettier/pull/2719) by [@sampi](https://github.com/sampi)
- [**feat(resolve-config): add `.sync()` method**](https://github.com/prettier/prettier/pull/2722) by [@ikatyang](https://github.com/ikatyang)
- [**refactor(bin): use `resolveConfigFile.sync()`**](https://github.com/prettier/prettier/pull/2728) by [@ikatyang](https://github.com/ikatyang)
- [**refactor(cli): separate files and make it pure as possible**](https://github.com/prettier/prettier/pull/2730) by [@ikatyang](https://github.com/ikatyang)
- [**Fix cosmiconfig dependency branch**](https://github.com/prettier/prettier/pull/2731) by [@josephfrazier](https://github.com/josephfrazier)
- [**Upgrade chalk to v2.1.0**](https://github.com/prettier/prettier/pull/2732) by [@josephfrazier](https://github.com/josephfrazier)
- [**Add CLI option '--config-precedence'**](https://github.com/prettier/prettier/pull/2733) by [@mitermayer](https://github.com/mitermayer)
- [**Normalize CSS case**](https://github.com/prettier/prettier/pull/2736) by [@lydell](https://github.com/lydell)
- [**Make run-external-typescript-tests.js cross-platform**](https://github.com/prettier/prettier/pull/2737) by [@lydell](https://github.com/lydell)
- [**test(integration): add more tests**](https://github.com/prettier/prettier/pull/2738) by [@ikatyang](https://github.com/ikatyang)
- [**chore(deps): remove devDependency `cross-spawn`**](https://github.com/prettier/prettier/pull/2739) by [@ikatyang](https://github.com/ikatyang)
- [**Ignore some things in coverage**](https://github.com/prettier/prettier/pull/2741) by [@lydell](https://github.com/lydell)
- [**Generalize run-external-typescript-tests.js**](https://github.com/prettier/prettier/pull/2742) by [@lydell](https://github.com/lydell)
- [**Improve lint-staged setup example by adding more filetypes**](https://github.com/prettier/prettier/pull/2746) by [@MoOx](https://github.com/MoOx)
- [**fixes dynamic imports**](https://github.com/prettier/prettier/pull/2748) by [@rkurbatov](https://github.com/rkurbatov)
- [**Refactor error handling**](https://github.com/prettier/prettier/pull/2750) by [@azz](https://github.com/azz)
- [**chore(github): add issue template**](https://github.com/prettier/prettier/pull/2755) by [@ikatyang](https://github.com/ikatyang)
- [**Fix: TypeScript never keyword (fixes [#2718](https://github.com/prettier/prettier/pull/2718))**](https://github.com/prettier/prettier/pull/2756) by [@JamesHenry](https://github.com/JamesHenry)
- [**Group last argument if it's an empty object with a comment**](https://github.com/prettier/prettier/pull/2758) by [@duailibe](https://github.com/duailibe)
- [**Use `files:` over `types:` in pre-commit configuration**](https://github.com/prettier/prettier/pull/2759) by [@asottile](https://github.com/asottile)
- [**refactor(runPrettier): reduce duplicate code**](https://github.com/prettier/prettier/pull/2764) by [@ikatyang](https://github.com/ikatyang)
- [**Change when to print ternaries in JSX mode**](https://github.com/prettier/prettier/pull/2768) by [@duailibe](https://github.com/duailibe)
- [**Fix chained logical expressions with objects/array/etc inlined**](https://github.com/prettier/prettier/pull/2770) by [@duailibe](https://github.com/duailibe)
- [**Add option to require @prettier or @format pragma**](https://github.com/prettier/prettier/pull/2772) by [@wbinnssmith](https://github.com/wbinnssmith)
- [**chore(build): update ISSUE_TEMPLATE.md before publish**](https://github.com/prettier/prettier/pull/2776) by [@ikatyang](https://github.com/ikatyang)
- [**Fix break on conditional expressions inside return**](https://github.com/prettier/prettier/pull/2779) by [@duailibe](https://github.com/duailibe)
- [**Support graphql(schema, `query`)**](https://github.com/prettier/prettier/pull/2781) by [@azz](https://github.com/azz)
- [**fix(prettierignore): support absolute filename**](https://github.com/prettier/prettier/pull/2783) by [@ambar](https://github.com/ambar)
- [**Keep conditional expressions in one line on method chains**](https://github.com/prettier/prettier/pull/2784) by [@duailibe](https://github.com/duailibe)
- [**fix(build): update ISSUE_TEMPLATE using regex `?:` instead of `?!`**](https://github.com/prettier/prettier/pull/2785) by [@ikatyang](https://github.com/ikatyang)
- [**Break closing paren of ConditionalExpression in member chains**](https://github.com/prettier/prettier/pull/2786) by [@duailibe](https://github.com/duailibe)
- [**fix webstorm integration guide**](https://github.com/prettier/prettier/pull/2796) by [@xsburg](https://github.com/xsburg)

### Issues resolved in this release

- [**Document missing CLI options**](https://github.com/prettier/prettier/issues/2698) reported by [@levithomason](https://github.com/levithomason)
- [**Formatting of Spread Properties differs between Babylon and TypeScript**](https://github.com/prettier/prettier/issues/2708) reported by [@mariusschulz](https://github.com/mariusschulz)
- [**Removal of the `declare` modifier from `enum`**](https://github.com/prettier/prettier/issues/2709) reported by [@mariusschulz](https://github.com/mariusschulz)
- [**Decimal formatting doesn't get all decimals in a rule.**](https://github.com/prettier/prettier/issues/2712) reported by [@itsgreggreg](https://github.com/itsgreggreg)
- [**Use resolveConfigFile.sync in the CLI**](https://github.com/prettier/prettier/issues/2726) reported by [@azz](https://github.com/azz)
- [**CSS: Normalize case (lower vs upper) on stuff**](https://github.com/prettier/prettier/issues/2653) reported by [@lydell](https://github.com/lydell)
- [**Dynamic import with webpackChunkName comment fails**](https://github.com/prettier/prettier/issues/1489) reported by [@pbomb](https://github.com/pbomb)
- [**TypeScript: never as type parameter causes error: unknown type: undefined**](https://github.com/prettier/prettier/issues/2718) reported by [@hccampos](https://github.com/hccampos)
- [**commented object values**](https://github.com/prettier/prettier/issues/2617) reported by [@sylvainbaronnet](https://github.com/sylvainbaronnet)
- [**Configuring pre-commit for jsx, TypeScript, tsx**](https://github.com/prettier/prettier/issues/2745) reported by [@reywright](https://github.com/reywright)
- [**JSX ternaries include parens**](https://github.com/prettier/prettier/issues/2729) reported by [@jasonLaster](https://github.com/jasonLaster)
- [**Chained Short Circuit Conditionals in JSX**](https://github.com/prettier/prettier/issues/2714) reported by [@brycehill](https://github.com/brycehill)
- [**Support @prettier pragma comment**](https://github.com/prettier/prettier/issues/2397) reported by [@ajhyndman](https://github.com/ajhyndman)
- [**No indentation after breaking return statement**](https://github.com/prettier/prettier/issues/2777) reported by [@jwbay](https://github.com/jwbay)
- [**Support graphql() fn and so make 2nd arg prettier**](https://github.com/prettier/prettier/issues/2780) reported by [@brikou](https://github.com/brikou)
- [**prettierignore: cannot use absolute filename**](https://github.com/prettier/prettier/issues/2782) reported by [@ambar](https://github.com/ambar)
- [**Weird JavaScript format**](https://github.com/prettier/prettier/issues/2775) reported by [@maxime1992](https://github.com/maxime1992)

---

Thank you to everyone who contributed to this release, be it through issue creation, code contribution, code review, or general commenting and feedback. Prettier is a community-run project and is able to continue to exist thanks to people like you. Thank you!
