---
title: "Compiler Error CS1705 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS1705"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1705"
ms.assetid: 3612a542-0256-4fed-b020-41691ef5a052
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS1705
Assembly 'AssemblyName1' uses 'TypeName' which has a higher version than referenced assembly 'AssemblyName2'  
  
 You are accessing a type that has a higher version number than the version number in a referenced assembly. Typically, this error is caused by the accidental use of two versions of the same assembly.  
  
 For example, suppose that you have two assemblies, Asmb1 and Asmb2. Assembly Asmb1 references version 1.0 of assembly Asmb2. Assembly Asmb1 also uses a class `MyClass` that was added to assembly Asmb2 in version 2.0. The compiler has unification rules for binding references, and a reference to `MyClass` in version 2.0 cannot be satisfied by version 1.0.  
  
## Example  
 The following more detailed example consists of four code modules:  
  
-   Two DLLs that are identical except for a version attribute.  
  
-   A third DLL that references the first two.  
  
-   A client that references only version 1.0 of the identical DLLs, but accesses a class from version 2.0.  
  
 The following code creates the first of the identical DLLs. For information about how to generate a key file, see [/keyfile (C# Compiler Options)](../../../csharp/language-reference/compiler-options/keyfile-compiler-option.md).  
  
```cs  
// CS1705a.cs  
  
// Compile by using the following command:   
//      csc /target:library /out:C:\\CS1705.dll /keyfile:mykey.snk CS1705a.cs  
  
// The DLL is created in the C:\ directory.  
  
// The AssemblyVersion attribute specifies version 1.0 for this DLL.  
  
[assembly:System.Reflection.AssemblyVersion("1.0")]  
public class Class1   
{  
   public void Method1() {}  
}  
```  
  
## Example  
 The following code defines version 2.0 of the assembly, as specified by the <xref:System.Reflection.AssemblyVersionAttribute> attribute.  
  
```cs  
// CS1705b.cs  
  
// Compile by using the following command:   
//     csc /target:library /out:CS1705.dll /keyfile:mykey.snk CS1705b.cs  
  
// The DLL is created in the current directory.  
  
// The AssemblyVersion attribute specifies version 2.0 for this DLL.  
  
[assembly:System.Reflection.AssemblyVersion("2.0")]  
public class Class1  
{  
    public void Method1() { }  
}  
  
```  
  
## Example  
 The following code references the two DLL versions that are defined in the preceding code. `AssemblyA` refers to the DLL created by CS1705a.cs (version 1.0). `AssemblyB` refers to the DLL created by CS1705b.cs (version 2.0). In `ClassC`, two methods are defined. The first, `Return1A`, returns an object of type `Class1A`, which is an alias for `Class1` from version 1.0 of the DLL. The second, `Return1B`, returns an object of type `Class1B`, which is an alias for `Class1` from version 2.0 of the DLL. The definition of `Return1A` creates a dependency on version 1.0; the definition of `Return1B` creates a dependency on version 2.0.  
  
```cs  
// CS1705c.cs  
  
// Compile by using the following command. AssemblyA refers to the DLL created by  
// CS1705a.cs (version 1.0). AssemblyB refers to the DLL created by CS1705b.cs  
// (version 2.0).  
//    csc /target:library /r:AssemblyA=C:\\CS1705.dll /r:AssemblyB=CS1705.dll CS1705c.cs  
  
extern alias AssemblyA;  
extern alias AssemblyB;  
  
// Class1A is an alias for type Class1 from VS1705a.cs, which is in version 1.0   
// of the assembly. Class1B is an alias for type Class1 from CS1705b.cs, which  
// is in version 2.0 of the assembly.  
  
using Class1A = AssemblyA::Class1;  
using Class1B = AssemblyB::Class1;  
  
// Method Return1A in ClassC returns an object of type Class1A, which is  
// Class1 from version 1.0 of the DLL. Method Return1B returns an object  
// of type Class1B, which is Class1 from version 2.0 of the DLL.  
  
public class ClassC  
{  
    // The following line creates a dependency on version 1.0 of CS1705.dll.  
    // This is not the source of the problem when ClassC is accessed from  
    // CS1705d.cs because CS1705d.cs references version 1.0 of the DLL.   
    // Therefore, type Class1A and the assembly have the same version.  
    public static Class1A Return1A() { return new Class1A(); }  
  
    // The following line creates a dependency on version 2.0 of CS1705.dll.  
    // This causes compiler error CS1705 when ClassC is accessed from     
    // CS1705d.cs, because CS1705d.cs does not reference version 2.0 of the   
    // DLL. Class1B is the alias for Class1 in version 2.0, and CS1705d.cs   
    // references version 1.0.  
    public static Class1B Return1B() { return new Class1B(); }  
}  
  
```  
  
## Example  
 The following code generates compiler error CS1705. It references the DLL created by CS1705a.cs (version 1.0). However, in the `Main` method, the code accesses `ClassC` from CS1705c.cs. `ClassC` uses a type that is defined in CS1705b.cs (version 2.0). This causes compiler error CS1705 because the type has a version number for CS1705.dll that is higher than the referenced version of CS1705.dll.  
  
```cs  
// CS1705d.cs  
  
// Compile by using the following command:  
//     csc /reference:C:\\CS1705.dll /reference:CS1705c.dll CS1705d.cs  
  
// C:\\CS1705.dll is version 1.0 of the assembly.  
  
class Tester   
{  
    static void Main()  
    {  
        // Return1A returns a type defined in version 1.0.  
        ClassC.Return1A().Method1();  
        // Return1B returns a type defined in version 2.0.  
        ClassC.Return1B().Method1();  
    }  
}  
  
```  
  
 You can resolve the error in one of the following ways:  
  
-   Update the code so that all files use the same version of the DLL.  
  
-   Add a reference to version 2.0 of the DLL to CS1705d.cs by using the following command to compile:  
  
     `csc /reference:C:\\CS1705.dll /reference:CS1705.dll /reference:CS1705c.dll CS1705d.cs`  
  
     Although the program compiles when you use this command, it still does not run. To enable the program to run, you can provide an application configuration file that includes a [\<dependentAssembly> element](http://msdn.microsoft.com/library/14e95627-dd79-4b82-ac85-e682aa3a31d8) that uses [\<assemblyIdentity>](http://msdn.microsoft.com/library/cea4d187-6398-4da4-af09-c1abc6a349c1) and [\<codeBase>](http://msdn.microsoft.com/library/d48a3983-2297-43ff-a14d-1f29d3995822) child elements to specify the location of version 1.0 of the DLL. For more information about configuration files, see [Configuring Apps](http://msdn.microsoft.com/library/86bd26d3-737e-4484-9782-19b17f34cd1f).  
  
## See Also  
 [extern alias](../../../csharp/language-reference/keywords/extern-alias.md)   
 [:: Operator](../../../csharp/language-reference/operators/namespace-alias-qualifer.md)   
 [Command-line Building With csc.exe](../../../csharp/language-reference/compiler-options/command-line-building-with-csc-exe.md)