---
title: "Compiler Error CS0425 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0425"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0425"
ms.assetid: cec0391c-a641-43bc-8557-92b23f6ca685
caps.latest.revision: 13
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0425
The constraints for type parameter 'type parameter' of method 'method' must match the constraints for type parameter 'type parameter' of interface method 'method'. Consider using an explicit interface implementation instead.  
  
 This error occurs if a virtual generic method is overridden in a derived class and the constraints on the method in the derived class do not match the constraints on the method in the base class. To avoid this error, make sure the `where` clause is identical in both declarations, or implement the interface explicitly.  
  
## Example  
 The following example generates CS0425:  
  
```  
// CS0425.cs  
  
class C1  
{  
}  
  
class C2  
{  
}  
  
interface IBase  
{  
    void F<ItemType>(ItemType item) where ItemType : C1;  
}  
  
class Derived : IBase  
{  
    public void F<ItemType>(ItemType item) where ItemType : C2  // CS0425  
    {  
    }  
}  
  
class CMain  
{  
    public static void Main()  
    {  
    }  
}  
```  
  
## Example  
 The constraints do not have to be a literal match, as long as the set of constraints has the same meaning. For example, the following is okay:  
  
```  
// CS0425b.cs  
  
interface J<Z>  
{  
}  
  
interface I<S>  
{  
    void F<T>(S s, T t) where T: J<S>, J<int>;  
}  
  
class C : I<int>  
{  
    public void F<X>(int s, X x) where X : J<int>  
    {  
    }  
  
    public static void Main()  
    {  
    }  
}  
```