---
title: "Compiler Error CS0473 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0473"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0473"
ms.assetid: 58eb141e-7da0-41c8-b868-7cd2a15f07f9
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0473
Explicit interface implementation 'method name' matches more than one interface member. Which interface member is actually chosen is implementation-dependent. Consider using a non-explicit implementation instead.  
  
 In some cases a generic method might acquire the same signature as a non-generic method. The problem is that there is no way in the common language infrastructure (CLI) metadata system to unambiguously state which method binds to which slot. It is up to the CLI to make that determination.  
  
> [!NOTE]
>  This error is raised in Visual Studio 2008 in places where it was not raised in Visual Studio 2005.  
  
## To correct this error  
  
1.  Eliminate the explicit implementation and just have the implicit implementation `public int TestMethod(int)` implement both of the interface methods.  
  
## Example  
 The following code generates CS0473:  
  
```  
// cs0473.cs  
public interface ITest<T>  
{  
    int TestMethod(int i);  
    int TestMethod(T i);  
}  
  
public class ImplementingClass : ITest<int>  
{  
    int ITest<int>.TestMethod(int i) // CS0473  
    {  
        return i + 1;  
    }  
  
    public int TestMethod(int i)  
    {  
        return i - 1;  
    }  
}  
  
class T  
{  
    static int Main()  
    {  
        ImplementingClass a = new ImplementingClass();  
        if (a.TestMethod(0) != -1)  
            return -1;  
  
        ITest<int> i_a = a;  
        System.Console.WriteLine(i_a.TestMethod(0).ToString());  
        if (i_a.TestMethod(0) != 1)  
            return -1;  
  
        return 0;  
    }  
}  
  
```  
  
## See Also  
 [Fabulous Adventures in Coding](http://blogs.msdn.com/ericlippert/archive/2006/04/06/570126.aspx)