---
title: "Compiler Error CS1623 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1623"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1623"
ms.assetid: e52bc2d6-5116-40a2-90bc-23a3fa2c73e7
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1623
Iterators cannot have ref or out parameters  
  
 This error occurs if an iterator method takes a `ref` or `out` parameter. To avoid this error, remove the `ref` or `out` keyword from the method signature.  
  
## Example  
 The following sample generates CS1623:  
  
```  
// CS1623.cs  
using System.Collections;  
  
class C : IEnumerable  
{  
    public IEnumerator GetEnumerator()  
    {  
        yield return 0;  
    }  
  
    // To resolve the error, remove ref  
    public IEnumerator GetEnumerator(ref int i)  // CS1623  
    {  
        yield return i;  
    }  
  
    // To resolve the error, remove out  
    public IEnumerator GetEnumerator(out float f)  // CS1623  
    {  
        f = 0.0F;  
        yield return f;  
    }  
}  
```