---
title: "Compiler Error CS1666 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1666"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1666"
ms.assetid: 4d62aa9c-71b9-4c6e-8141-2426d20ac243
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1666
You cannot use fixed size buffers contained in unfixed expressions. Try using the fixed statement.  
  
 This error occurs if you use the fixed sized buffer in an expression involving a class that is not itself fixed. The runtime is free to move the unfixed class around to optimize memory access, which could lead to errors when using the fixed sized buffer. To avoid this error, use the `fixed` keyword on the statement.  
  
## Example  
 The following sample generates CS1666.  
  
```  
// CS1666.cs  
// compile with: /unsafe /target:library  
unsafe struct S  
{  
   public fixed int buffer[1];  
}  
  
unsafe class Test  
{  
   S field = new S();  
  
   private bool example1()  
   {  
      return (field.buffer[0] == 0);   // CS1666 error  
   }  
  
   private bool example2()  
   {  
      // OK  
      fixed (S* p = &field)  
      {  
         return (p->buffer[0] == 0);  
      }  
   }  
  
   private bool example3()  
   {  
      S local = new S();  
      return (local.buffer[0] == 0);   
   }   
}  
```