---
title: "Option Strict On does not allow narrowing in implicit type conversions between method &#39;&lt;methodname&gt;&#39; and delegate &#39;&lt;delegatename&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36663"
  - "vbc36663"
helpviewer_keywords: 
  - "BC36663"
ms.assetid: fefc7ab5-b587-4ff9-a6bc-4c4e5d4b6b29
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Option Strict On does not allow narrowing in implicit type conversions between method &#39;&lt;methodname&gt;&#39; and delegate &#39;&lt;delegatename&gt;&#39;
With `Option Strict` on, you cannot have a narrowing conversion between the data type of a parameter in a delegate and the corresponding parameter of a function or `Sub` assigned to a variable of that delegate type. For example, function delegate `Del` has one parameter of type `Integer`, and functions `Conversion1`, `Conversion2`, and `Conversion3` have one parameter of different numeric types.  
  
```vb  
Delegate Function Del(ByVal p As Integer) As String  
  
Function Conversion1(ByVal n As Integer) As String  
    Return "Valid"  
End Function  
  
Function Conversion2(ByVal n As Long) As String  
    Return "Valid"  
End Function  
  
Function Conversion3(ByVal n As Short) As String  
    Return "Not valid"  
End Function  
```  
  
 Because there is a widening conversion from `Integer` to `Integer` and to `Long`, the following assignments are valid.  
  
```vb  
' Valid.  
Dim funDel1 As Del = AddressOf Conversion1  
Dim funDel2 As Del = AddressOf Conversion2  
```  
  
 The conversion from `Integer` to `Short` is a narrowing conversion. Therefore, the following assignment is not valid.  
  
```vb  
' Not valid.  
Dim funDel3 As Del = AddressOf Conversion3  
```  
  
 Error ID: BC36663  
  
## To correct this error  
  
-   Change the data type of the parameter in the delegate or the method so that the required widening relationship exists.  
  
## See Also  
 [Relaxed Delegate Conversion](../../visual-basic/programming-guide/language-features/delegates/relaxed-delegate-conversion.md)   
 [Delegates](../../visual-basic/programming-guide/language-features/delegates/index.md)   
 [Widening and Narrowing Conversions](../../visual-basic/programming-guide/language-features/data-types/widening-and-narrowing-conversions.md)   
 [NOT IN BUILD: Delegates and the AddressOf Operator](http://msdn.microsoft.com/en-us/7b2ed932-8598-4355-b2f7-5cedb23ee86f)