#
#	CMake Find MetaCall library by Parra Studios
#	CMake script to find and include MetaCall library for development.
#
#	Copyright (C) 2016 - 2021 Vicente Eduardo Ferrer Garcia <vic798@gmail.com>
#
#	Licensed under the Apache License, Version 2.0 (the "License");
#	you may not use this file except in compliance with the License.
#	You may obtain a copy of the License at
#
#		http://www.apache.org/licenses/LICENSE-2.0
#
#	Unless required by applicable law or agreed to in writing, software
#	distributed under the License is distributed on an "AS IS" BASIS,
#	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#	See the License for the specific language governing permissions and
#	limitations under the License.
#

# Find MetaCall library and include paths
#
# METACALL_FOUND - True if MetaCall library was found
# METACALL_INCLUDE_DIRS - MetaCall headers path
# METACALL_LIBRARIES - List of MetaCall libraries
# METACALL_DEFINITIONS - MetaCall definitions
#
# Example of usage:
#
# # MetaCall Library
# find_package(MetaCall REQUIRED)
#
# if(NOT METACALL_FOUND)
# 	message(STATUS "MetaCall libraries not found")
# 	return()
# endif()

# TODO: Remove this, the find file must be autogenerated

# Prevent vervosity if already included
if(METACALL_FOUND)
	set(METACALL_FIND_QUITELY TRUE)
endif()

# Default includes install location
set(METACALL_INCLUDE_PATHS
	"/usr/local/include"
)

# MetaCall include path
find_path(METACALL_INCLUDE_DIR
	NAMES metacall/metacall.h
	PATHS ${METACALL_INCLUDE_PATHS}
	DOC "MetaCall includes"
)

# Default library install location
set(METACALL_LIBRARY_PATHS
	"${METACALL_ROOT_DIR}"
	"/usr/local/lib"
)

# MetaCall library path
find_library(METACALL_LIBRARY
	NAMES metacall libmetacall.dll libmetacall.lib libmetacall.a libmetacall.so libmetacall.dylib
	PATHS ${METACALL_LIBRARY_PATHS}
	DOC "MetaCall library"
)

# Find package
include(FindPackageHandleStandardArgs)

find_package_handle_standard_args(METACALL DEFAULT_MSG METACALL_INCLUDE_DIR METACALL_LIBRARY)

if(METACALL_FOUND)
	set(METACALL_LIBRARIES ${METACALL_LIBRARY})
	set(METACALL_INCLUDE_DIRS ${METACALL_INCLUDE_DIR})
	set(METACALL_DEFINITIONS)
endif()

# Ignore local variables
mark_as_advanced(METACALL_INCLUDE_DIRS METACALL_LIBRARIES METACALL_DEFINITIONS)
