// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Diagnostics
{
    // DebuggerBrowsableState states are defined as follows:
    //     Never       element should never show
    //     Expanded    expansion of the class is done, so that all visible internal members are shown
    //     Collapsed   expansion of the class is not performed. Internal visible members are hidden
    //     RootHidden  The target element itself should not be shown, but should instead be
    //                 automatically expanded to have its members displayed.
    // Default value is collapsed

    // Please also change the code which validates DebuggerBrowsableState variable (in this file)
    // if you change this enum.
    public enum DebuggerBrowsableState
    {
        Never = 0,
        // Expanded is not supported in this release
        // Expanded = 1,
        Collapsed = 2,
        RootHidden = 3
    }


    // the one currently supported with the csee.dat
    // (mcee.dat, autoexp.dat) file.
    [AttributeUsage(AttributeTargets.Field | AttributeTargets.Property, AllowMultiple = false)]
    public sealed class DebuggerBrowsableAttribute : Attribute
    {
        public DebuggerBrowsableAttribute(DebuggerBrowsableState state)
        {
            if (state < DebuggerBrowsableState.Never || state > DebuggerBrowsableState.RootHidden)
                throw new ArgumentOutOfRangeException(nameof(state));

            State = state;
        }
        public DebuggerBrowsableState State { get; }
    }
}
