// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Globalization
{
    public static partial class CharUnicodeInfo
    {
        // THE FOLLOWING DATA IS AUTO GENERATED BY GenUnicodeProp program UNDER THE TOOLS FOLDER
        // PLEASE DON'T MODIFY BY HAND


        // 11:5:4 index table of the Unicode category data.
        private static ReadOnlySpan<byte> CategoryLevel1Index => new byte[2176]
        {
            0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
            0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1b, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1c,
            0x1d, 0x1a, 0x1e, 0x1f, 0x20, 0x21, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x22, 0x23, 0x23, 0x23, 0x23,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x25, 0x26, 0x27, 0x28,
            0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
            0x1a, 0x39, 0x3a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x1a, 0x1a, 0x3c, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x1a, 0x3d, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x1a, 0x3e, 0x3b, 0x3f, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x40, 0x1a, 0x41, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x42, 0x43, 0x3b, 0x3b, 0x3b, 0x3b, 0x44, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a, 0x3b, 0x3b,
            0x4b, 0x3b, 0x3b, 0x3b, 0x4c, 0x3b, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x3b, 0x3b,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x55, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x56, 0x57, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x58, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a,
            0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x59, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x1a, 0x5a, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x5b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x5c,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x5c
        };

        private static ReadOnlySpan<byte> CategoryLevel2Index => new byte[5952]
        {
            0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x07, 0x00,
            0x08, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0b, 0x00, 0x0c, 0x00, 0x0d, 0x00, 0x0e, 0x00, 0x0f, 0x00,
            0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x11, 0x00, 0x12, 0x00, 0x10, 0x00, 0x10, 0x00, 0x13, 0x00,
            0x14, 0x00, 0x15, 0x00, 0x16, 0x00, 0x17, 0x00, 0x18, 0x00, 0x19, 0x00, 0x10, 0x00, 0x1a, 0x00,
            0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x1b, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
            0x0e, 0x00, 0x1d, 0x00, 0x0e, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x20, 0x00, 0x21, 0x00, 0x22, 0x00,
            0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x24, 0x00,
            0x25, 0x00, 0x26, 0x00, 0x27, 0x00, 0x0e, 0x00, 0x28, 0x00, 0x29, 0x00, 0x10, 0x00, 0x2a, 0x00,
            0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x10, 0x00, 0x10, 0x00,
            0x2b, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x2c, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
            0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x2d, 0x00, 0x0c, 0x00, 0x2e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
            0x2f, 0x00, 0x30, 0x00, 0x23, 0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35, 0x00,
            0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x38, 0x00, 0x39, 0x00, 0x23, 0x00, 0x3a, 0x00, 0x3b, 0x00,
            0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x3c, 0x00, 0x3d, 0x00, 0x3e, 0x00,
            0x3f, 0x00, 0x40, 0x00, 0x38, 0x00, 0x23, 0x00, 0x41, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
            0x38, 0x00, 0x38, 0x00, 0x42, 0x00, 0x43, 0x00, 0x44, 0x00, 0x33, 0x00, 0x45, 0x00, 0x46, 0x00,
            0x33, 0x00, 0x47, 0x00, 0x48, 0x00, 0x49, 0x00, 0x33, 0x00, 0x4a, 0x00, 0x4b, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x38, 0x00, 0x4d, 0x00, 0x4c, 0x00, 0x4e, 0x00, 0x4f, 0x00, 0x23, 0x00,
            0x50, 0x00, 0x51, 0x00, 0x51, 0x00, 0x52, 0x00, 0x53, 0x00, 0x54, 0x00, 0x55, 0x00, 0x56, 0x00,
            0x57, 0x00, 0x58, 0x00, 0x59, 0x00, 0x5a, 0x00, 0x5b, 0x00, 0x5c, 0x00, 0x5d, 0x00, 0x5e, 0x00,
            0x5f, 0x00, 0x58, 0x00, 0x59, 0x00, 0x60, 0x00, 0x61, 0x00, 0x62, 0x00, 0x63, 0x00, 0x64, 0x00,
            0x65, 0x00, 0x66, 0x00, 0x59, 0x00, 0x67, 0x00, 0x68, 0x00, 0x69, 0x00, 0x5d, 0x00, 0x6a, 0x00,
            0x6b, 0x00, 0x58, 0x00, 0x59, 0x00, 0x6c, 0x00, 0x6d, 0x00, 0x6e, 0x00, 0x5d, 0x00, 0x6f, 0x00,
            0x70, 0x00, 0x71, 0x00, 0x72, 0x00, 0x73, 0x00, 0x74, 0x00, 0x75, 0x00, 0x63, 0x00, 0x76, 0x00,
            0x77, 0x00, 0x78, 0x00, 0x59, 0x00, 0x79, 0x00, 0x7a, 0x00, 0x7b, 0x00, 0x5d, 0x00, 0x7c, 0x00,
            0x7d, 0x00, 0x78, 0x00, 0x59, 0x00, 0x7e, 0x00, 0x7f, 0x00, 0x80, 0x00, 0x5d, 0x00, 0x81, 0x00,
            0x82, 0x00, 0x78, 0x00, 0x51, 0x00, 0x83, 0x00, 0x84, 0x00, 0x85, 0x00, 0x5d, 0x00, 0x86, 0x00,
            0x87, 0x00, 0x88, 0x00, 0x51, 0x00, 0x89, 0x00, 0x8a, 0x00, 0x8b, 0x00, 0x63, 0x00, 0x8c, 0x00,
            0x8d, 0x00, 0x51, 0x00, 0x51, 0x00, 0x8e, 0x00, 0x8f, 0x00, 0x90, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x91, 0x00, 0x92, 0x00, 0x93, 0x00, 0x94, 0x00, 0x95, 0x00, 0x96, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x97, 0x00, 0x98, 0x00, 0x99, 0x00, 0x9a, 0x00, 0x9b, 0x00, 0x51, 0x00, 0x9c, 0x00, 0x9d, 0x00,
            0x9e, 0x00, 0x9f, 0x00, 0x23, 0x00, 0xa0, 0x00, 0xa1, 0x00, 0xa2, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0xa3, 0x00, 0xa4, 0x00, 0xa5, 0x00, 0xa6, 0x00, 0xa7, 0x00, 0xa8, 0x00,
            0xa9, 0x00, 0xaa, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0xab, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0xac, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xad, 0x00, 0xae, 0x00, 0x51, 0x00, 0x51, 0x00,
            0xad, 0x00, 0x51, 0x00, 0x51, 0x00, 0xaf, 0x00, 0xb0, 0x00, 0xb1, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0xb0, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xb2, 0x00, 0xb3, 0x00, 0xb4, 0x00,
            0x51, 0x00, 0xb5, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0xb6, 0x00,
            0xb7, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xb8, 0x00, 0x51, 0x00,
            0xb9, 0x00, 0xba, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xbb, 0x00, 0xbc, 0x00,
            0xbd, 0x00, 0xbe, 0x00, 0x51, 0x00, 0xbf, 0x00, 0x51, 0x00, 0xc0, 0x00, 0xbd, 0x00, 0xc1, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xc2, 0x00, 0xc3, 0x00, 0xc4, 0x00, 0xc5, 0x00, 0xc6, 0x00,
            0xc7, 0x00, 0xc5, 0x00, 0x51, 0x00, 0x51, 0x00, 0xc8, 0x00, 0x51, 0x00, 0x51, 0x00, 0xc9, 0x00,
            0xca, 0x00, 0x51, 0x00, 0xcb, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xcc, 0x00,
            0x51, 0x00, 0xcd, 0x00, 0xce, 0x00, 0xcf, 0x00, 0xd0, 0x00, 0x51, 0x00, 0xd1, 0x00, 0xd2, 0x00,
            0x51, 0x00, 0x51, 0x00, 0xd3, 0x00, 0x51, 0x00, 0xd4, 0x00, 0xd5, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0x51, 0x00, 0xd7, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xd8, 0x00, 0xd9, 0x00, 0xda, 0x00,
            0xc5, 0x00, 0xc5, 0x00, 0xdb, 0x00, 0xdc, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xdd, 0x00, 0x51, 0x00, 0x51, 0x00, 0xde, 0x00, 0xdf, 0x00, 0xa5, 0x00, 0xe0, 0x00, 0xe1, 0x00,
            0xe2, 0x00, 0x51, 0x00, 0xe3, 0x00, 0xe4, 0x00, 0x51, 0x00, 0x51, 0x00, 0xe5, 0x00, 0xe6, 0x00,
            0x51, 0x00, 0x51, 0x00, 0xe7, 0x00, 0xe8, 0x00, 0xe9, 0x00, 0xe4, 0x00, 0x51, 0x00, 0xea, 0x00,
            0xeb, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0xec, 0x00, 0xed, 0x00, 0xee, 0x00, 0xef, 0x00, 0xf0, 0x00,
            0x0e, 0x00, 0x0e, 0x00, 0xf1, 0x00, 0xf2, 0x00, 0xf2, 0x00, 0xf2, 0x00, 0xf3, 0x00, 0xf4, 0x00,
            0x0e, 0x00, 0xf5, 0x00, 0xf2, 0x00, 0xf2, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0xf6, 0x00,
            0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
            0x10, 0x00, 0xf7, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00,
            0xf8, 0x00, 0xf9, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf9, 0x00, 0xfa, 0x00, 0xf8, 0x00, 0xfb, 0x00,
            0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfd, 0x00, 0xfe, 0x00, 0xff, 0x00, 0x00, 0x01, 0x01, 0x01,
            0x02, 0x01, 0x03, 0x01, 0x04, 0x01, 0x05, 0x01, 0x06, 0x01, 0x07, 0x01, 0x08, 0x01, 0x09, 0x01,
            0x0a, 0x01, 0x0b, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x4c, 0x00, 0x0d, 0x01, 0x0e, 0x01, 0x0f, 0x01,
            0x10, 0x01, 0x11, 0x01, 0x12, 0x01, 0x13, 0x01, 0x14, 0x01, 0x15, 0x01, 0x16, 0x01, 0x16, 0x01,
            0x17, 0x01, 0x18, 0x01, 0x19, 0x01, 0xd6, 0x00, 0x1a, 0x01, 0x1b, 0x01, 0xd6, 0x00, 0x1c, 0x01,
            0x1d, 0x01, 0x1e, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01,
            0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01,
            0x1f, 0x01, 0xd6, 0x00, 0x20, 0x01, 0x21, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x23, 0x01,
            0xd6, 0x00, 0x24, 0x01, 0x1d, 0x01, 0x25, 0x01, 0xd6, 0x00, 0x26, 0x01, 0x27, 0x01, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0x28, 0x01, 0x4c, 0x00, 0x29, 0x01, 0x4c, 0x00, 0x15, 0x01, 0x15, 0x01,
            0x2a, 0x01, 0x2b, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x2c, 0x01, 0x15, 0x01,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x2d, 0x01, 0x2e, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x2f, 0x01,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x30, 0x01, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0x31, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x32, 0x01, 0x33, 0x01,
            0x15, 0x01, 0x34, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x35, 0x01, 0x1d, 0x01, 0x36, 0x01, 0x1d, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01,
            0x37, 0x01, 0x38, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x39, 0x01, 0x1d, 0x01, 0x3a, 0x01,
            0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01,
            0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01, 0x1d, 0x01,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x1d, 0x01, 0x3b, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x3c, 0x01,
            0xd6, 0x00, 0x3d, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x3e, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x3f, 0x01,
            0x0c, 0x00, 0x0c, 0x00, 0x40, 0x01, 0x0e, 0x00, 0x0e, 0x00, 0x41, 0x01, 0x42, 0x01, 0x43, 0x01,
            0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x44, 0x01, 0x45, 0x01,
            0x0e, 0x00, 0x0e, 0x00, 0x46, 0x01, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x47, 0x01, 0x48, 0x01,
            0x51, 0x00, 0x49, 0x01, 0x4a, 0x01, 0x4a, 0x01, 0x4a, 0x01, 0x4a, 0x01, 0x23, 0x00, 0x23, 0x00,
            0x4b, 0x01, 0x4c, 0x01, 0x4d, 0x01, 0x4e, 0x01, 0x4f, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xd6, 0x00, 0x50, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x51, 0x01,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x52, 0x01, 0x4c, 0x00, 0x53, 0x01,
            0x54, 0x01, 0x55, 0x01, 0x56, 0x01, 0x57, 0x01, 0x8d, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x58, 0x01, 0xb7, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x59, 0x01,
            0x5a, 0x01, 0x51, 0x00, 0x51, 0x00, 0x8d, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0xcd, 0x00, 0x5b, 0x01, 0x51, 0x00, 0x5c, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x51, 0x01, 0x51, 0x00,
            0x22, 0x01, 0x5d, 0x01, 0x5e, 0x01, 0x22, 0x01, 0x5f, 0x01, 0x60, 0x01, 0x22, 0x01, 0x61, 0x01,
            0x5e, 0x01, 0x22, 0x01, 0x22, 0x01, 0x62, 0x01, 0x63, 0x01, 0x22, 0x01, 0x22, 0x01, 0x64, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x65, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x66, 0x01, 0x22, 0x01, 0x67, 0x01,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xcc, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x68, 0x01, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x9c, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x28, 0x01, 0x51, 0x00, 0x51, 0x00, 0xea, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x69, 0x01, 0x51, 0x00, 0x6a, 0x01, 0x4c, 0x00, 0x10, 0x00, 0x10, 0x00, 0x6b, 0x01, 0x6c, 0x01,
            0x10, 0x00, 0x6d, 0x01, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x6e, 0x01, 0x6f, 0x01,
            0x22, 0x00, 0x70, 0x01, 0x71, 0x01, 0x72, 0x01, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x73, 0x01,
            0x74, 0x01, 0x75, 0x01, 0x76, 0x01, 0x77, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x78, 0x01,
            0x79, 0x01, 0x51, 0x00, 0x7a, 0x01, 0x7b, 0x01, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x7c, 0x01,
            0x7d, 0x01, 0x51, 0x00, 0x51, 0x00, 0x7e, 0x01, 0x7f, 0x01, 0xc5, 0x00, 0x23, 0x00, 0x80, 0x01,
            0xe4, 0x00, 0x51, 0x00, 0x81, 0x01, 0x51, 0x00, 0x82, 0x01, 0x83, 0x01, 0x51, 0x00, 0x9c, 0x00,
            0x50, 0x00, 0x51, 0x00, 0x51, 0x00, 0x84, 0x01, 0x85, 0x01, 0x86, 0x01, 0x87, 0x01, 0x88, 0x01,
            0x51, 0x00, 0x51, 0x00, 0x89, 0x01, 0x8a, 0x01, 0x8b, 0x01, 0x8c, 0x01, 0x51, 0x00, 0x8d, 0x01,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x8e, 0x01, 0x8f, 0x01, 0x90, 0x01, 0x91, 0x01, 0x92, 0x01,
            0x93, 0x01, 0x94, 0x01, 0x4a, 0x01, 0x0e, 0x00, 0x0e, 0x00, 0x95, 0x01, 0x96, 0x01, 0x0e, 0x00,
            0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x51, 0x00, 0x51, 0x00, 0x97, 0x01, 0xc5, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x98, 0x01, 0x51, 0x00, 0x99, 0x01, 0x51, 0x00, 0x51, 0x00, 0xd3, 0x00,
            0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01,
            0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01,
            0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01,
            0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01, 0x9a, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xd1, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xd4, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x9c, 0x01, 0x9d, 0x01, 0x9e, 0x01, 0x9f, 0x01, 0xa0, 0x01, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
            0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0xa1, 0x01, 0xa2, 0x01, 0xa3, 0x01, 0x38, 0x00, 0x38, 0x00,
            0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
            0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
            0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0xa4, 0x01, 0x4c, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
            0x38, 0x00, 0xa5, 0x01, 0x38, 0x00, 0x38, 0x00, 0xa6, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0xa7, 0x01,
            0x23, 0x00, 0xa8, 0x01, 0x23, 0x00, 0xa9, 0x01, 0xaa, 0x01, 0xab, 0x01, 0xac, 0x01, 0xad, 0x01,
            0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0xae, 0x01,
            0xaf, 0x01, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0xb0, 0x01, 0xb1, 0x01, 0xb2, 0x01,
            0x51, 0x00, 0xb3, 0x01, 0x51, 0x00, 0xcd, 0x00, 0xb4, 0x01, 0xb5, 0x01, 0xb6, 0x01, 0xb7, 0x01,
            0xb8, 0x01, 0x51, 0x00, 0xb1, 0x00, 0xb9, 0x01, 0xd1, 0x00, 0xd1, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x5c, 0x01,
            0xba, 0x01, 0xbb, 0x01, 0xbb, 0x01, 0xbc, 0x01, 0xbd, 0x01, 0xbd, 0x01, 0xbd, 0x01, 0xbe, 0x01,
            0xbf, 0x01, 0x53, 0x01, 0xc0, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x22, 0x01, 0x22, 0x01, 0xc1, 0x01,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x9c, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x69, 0x00, 0xc2, 0x01, 0xc3, 0x01,
            0x51, 0x00, 0x51, 0x00, 0xc4, 0x01, 0x51, 0x00, 0xc5, 0x01, 0x51, 0x00, 0x51, 0x00, 0xc6, 0x01,
            0x51, 0x00, 0xc7, 0x01, 0x51, 0x00, 0x51, 0x00, 0xc8, 0x01, 0xc9, 0x01, 0x4c, 0x00, 0x4c, 0x00,
            0x0c, 0x00, 0x0c, 0x00, 0xca, 0x01, 0x0e, 0x00, 0x0e, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0xd1, 0x00, 0xc5, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0xcb, 0x01, 0x0e, 0x00, 0xcc, 0x01,
            0x51, 0x00, 0x51, 0x00, 0xcd, 0x01, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xce, 0x01, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x49, 0x01, 0x51, 0x00, 0xcc, 0x00, 0xcd, 0x01, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xcf, 0x01, 0x33, 0x00, 0x33, 0x00, 0xd0, 0x01, 0x33, 0x00, 0xd1, 0x01, 0x33, 0x00, 0xd2, 0x01,
            0x33, 0x00, 0xd3, 0x01, 0xd4, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x33, 0x00, 0xd5, 0x01,
            0x33, 0x00, 0xd6, 0x01, 0x33, 0x00, 0xd7, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0xd8, 0x01, 0xd9, 0x01, 0xda, 0x01, 0xd9, 0x01, 0xd9, 0x01,
            0xdb, 0x01, 0xdc, 0x01, 0x33, 0x00, 0xdd, 0x01, 0xde, 0x01, 0xdf, 0x01, 0x33, 0x00, 0xe0, 0x01,
            0x33, 0x00, 0xe1, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0xe2, 0x01, 0x33, 0x00, 0xe3, 0x01, 0xe4, 0x01,
            0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0xe5, 0x01, 0x33, 0x00, 0xe6, 0x01, 0x33, 0x00, 0xe7, 0x01,
            0x33, 0x00, 0xe8, 0x01, 0xe9, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0xea, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xeb, 0x01, 0xeb, 0x01, 0xeb, 0x01, 0xec, 0x01, 0xed, 0x01, 0xed, 0x01, 0xed, 0x01, 0xee, 0x01,
            0x38, 0x00, 0x38, 0x00, 0xef, 0x01, 0xf0, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0xf1, 0x01, 0xf2, 0x01,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x33, 0x00, 0xe1, 0x01, 0xf3, 0x01, 0x38, 0x00, 0x42, 0x00, 0xf4, 0x01, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xf5, 0x01, 0x51, 0x00, 0x51, 0x00, 0xf6, 0x01, 0xf7, 0x01, 0xf8, 0x01, 0xf9, 0x01, 0xfa, 0x01,
            0xe2, 0x00, 0x51, 0x00, 0x51, 0x00, 0xfb, 0x01, 0xfc, 0x01, 0x51, 0x00, 0xc9, 0x00, 0xc5, 0x00,
            0xfd, 0x01, 0x51, 0x00, 0xfe, 0x01, 0xff, 0x01, 0x00, 0x02, 0x51, 0x00, 0x51, 0x00, 0x01, 0x02,
            0xe2, 0x00, 0x51, 0x00, 0x51, 0x00, 0x02, 0x02, 0x03, 0x02, 0x04, 0x02, 0x05, 0x02, 0x06, 0x02,
            0x51, 0x00, 0x66, 0x00, 0x07, 0x02, 0x08, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x09, 0x02, 0x0a, 0x02, 0x0b, 0x02, 0x51, 0x00, 0x51, 0x00, 0x0c, 0x02, 0x0d, 0x02, 0xc5, 0x00,
            0x0e, 0x02, 0x58, 0x00, 0x59, 0x00, 0x0f, 0x02, 0x10, 0x02, 0x11, 0x02, 0x12, 0x02, 0x13, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x14, 0x02, 0x15, 0x02, 0x16, 0x02, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x17, 0x02, 0x18, 0x02, 0xc5, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x19, 0x02, 0x1a, 0x02, 0x1b, 0x02, 0x1c, 0x02, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x1d, 0x02, 0x1e, 0x02, 0xc5, 0x00, 0x1f, 0x02, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x20, 0x02, 0x21, 0x02, 0xc5, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0xb2, 0x00, 0x22, 0x02, 0x23, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x07, 0x02, 0x24, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x99, 0x00, 0x25, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x26, 0x02, 0x51, 0x00, 0x51, 0x00, 0x27, 0x02, 0x28, 0x02, 0x29, 0x02, 0x51, 0x00, 0x51, 0x00,
            0x2a, 0x02, 0x2b, 0x02, 0x2c, 0x02, 0x4c, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xc9, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x59, 0x00, 0x51, 0x00, 0x19, 0x02, 0x2d, 0x02, 0x2e, 0x02, 0x99, 0x00, 0xb4, 0x00, 0x2f, 0x02,
            0x51, 0x00, 0x30, 0x02, 0x31, 0x02, 0x32, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x33, 0x02, 0x51, 0x00, 0x51, 0x00, 0x34, 0x02, 0x35, 0x02, 0xc5, 0x00, 0x36, 0x02, 0x51, 0x00,
            0x37, 0x02, 0x38, 0x02, 0xc5, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x51, 0x00, 0x39, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0xd4, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x16, 0x01, 0x16, 0x01, 0x16, 0x01, 0x16, 0x01, 0x16, 0x01, 0x16, 0x01, 0x3a, 0x02, 0x3b, 0x02,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x98, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0xcd, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x49, 0x01, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xc9, 0x00, 0x51, 0x00, 0xcd, 0x00, 0x86, 0x01, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x51, 0x00, 0xd1, 0x00, 0x3c, 0x02,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x3d, 0x02, 0x3e, 0x02, 0x3f, 0x02, 0x40, 0x02, 0x41, 0x02,
            0x51, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0e, 0x00, 0x0e, 0x00,
            0xbb, 0x01, 0x42, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xd2, 0x00, 0x43, 0x02, 0x44, 0x02, 0x45, 0x02,
            0xfa, 0x01, 0x46, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x47, 0x02, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x48, 0x02,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x49, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0xcd, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xd3, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x5c, 0x01, 0x9c, 0x00,
            0xc9, 0x00, 0x4a, 0x02, 0x4b, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x4c, 0x02,
            0x22, 0x01, 0x22, 0x01, 0x4d, 0x02, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x4e, 0x02, 0x4f, 0x02,
            0x50, 0x02, 0x22, 0x01, 0x51, 0x02, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x52, 0x02, 0x4c, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x53, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0xbb, 0x01, 0x54, 0x02,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x28, 0x01, 0xbb, 0x01, 0x55, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x0c, 0x00, 0x56, 0x02, 0x0e, 0x00, 0x57, 0x02, 0x58, 0x02, 0x59, 0x02, 0xf8, 0x00, 0x0c, 0x00,
            0x5a, 0x02, 0x5b, 0x02, 0x5c, 0x02, 0x5d, 0x02, 0x5e, 0x02, 0x0c, 0x00, 0x56, 0x02, 0x0e, 0x00,
            0x5f, 0x02, 0x60, 0x02, 0x0e, 0x00, 0x61, 0x02, 0x62, 0x02, 0x63, 0x02, 0x64, 0x02, 0x0c, 0x00,
            0x65, 0x02, 0x0e, 0x00, 0x0c, 0x00, 0x56, 0x02, 0x0e, 0x00, 0x57, 0x02, 0x58, 0x02, 0x0e, 0x00,
            0xf8, 0x00, 0x0c, 0x00, 0x5a, 0x02, 0x64, 0x02, 0x0c, 0x00, 0x65, 0x02, 0x0e, 0x00, 0x0c, 0x00,
            0x56, 0x02, 0x0e, 0x00, 0x66, 0x02, 0x0c, 0x00, 0x67, 0x02, 0x68, 0x02, 0x69, 0x02, 0x6a, 0x02,
            0x0e, 0x00, 0x6b, 0x02, 0x0c, 0x00, 0x6c, 0x02, 0x6d, 0x02, 0x6e, 0x02, 0x6f, 0x02, 0x0e, 0x00,
            0x70, 0x02, 0x0c, 0x00, 0x71, 0x02, 0x0e, 0x00, 0x72, 0x02, 0x73, 0x02, 0x73, 0x02, 0x73, 0x02,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01,
            0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x74, 0x02, 0x23, 0x00, 0x23, 0x00, 0x75, 0x02, 0x76, 0x02,
            0x77, 0x02, 0x78, 0x02, 0x30, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x79, 0x02, 0x7a, 0x02, 0x7b, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00,
            0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x33, 0x00, 0x7c, 0x02, 0x7d, 0x02, 0x4c, 0x00, 0x4c, 0x00,
            0xeb, 0x01, 0xeb, 0x01, 0x7e, 0x02, 0xed, 0x01, 0x7f, 0x02, 0x80, 0x02, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x81, 0x02,
            0x82, 0x02, 0x82, 0x02, 0x83, 0x02, 0x84, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x85, 0x02, 0x38, 0x00, 0x86, 0x02, 0x87, 0x02, 0x88, 0x02, 0x89, 0x02, 0x8a, 0x02, 0x8b, 0x02,
            0x8c, 0x02, 0x8d, 0x02, 0x8e, 0x02, 0x8d, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x8f, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0x53, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0x51, 0x01, 0x3f, 0x01, 0x90, 0x02, 0x90, 0x02, 0x90, 0x02, 0xd6, 0x00, 0x52, 0x01,
            0x91, 0x02, 0x22, 0x01, 0x67, 0x01, 0x22, 0x01, 0x22, 0x01, 0x22, 0x01, 0x92, 0x02, 0x22, 0x01,
            0x22, 0x01, 0x22, 0x01, 0x93, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x94, 0x02, 0x22, 0x01,
            0x95, 0x02, 0x22, 0x01, 0x22, 0x01, 0x96, 0x02, 0x52, 0x02, 0x97, 0x02, 0x52, 0x01, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x98, 0x02,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x99, 0x02, 0x9a, 0x02, 0xb5, 0x00,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x51, 0x01,
            0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x9b, 0x02, 0x4c, 0x00, 0x4c, 0x00,
            0x53, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x9c, 0x02, 0xb5, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0x9c, 0x02, 0xd6, 0x00, 0x9d, 0x02, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x53, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0x3f, 0x01, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00, 0x9e, 0x02,
            0xd6, 0x00, 0xd6, 0x00, 0x9f, 0x02, 0xb5, 0x00, 0x9f, 0x02, 0xd6, 0x00, 0xd6, 0x00, 0xd6, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x9d, 0x02, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x49, 0x01, 0x4c, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0xd2, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0xd1, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x48, 0x02, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00,
            0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x51, 0x00, 0x69, 0x00, 0x4c, 0x00,
            0x51, 0x00, 0xd1, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0xa0, 0x02, 0x4c, 0x00, 0xa1, 0x02, 0xa1, 0x02, 0xa1, 0x02, 0xa1, 0x02, 0xa1, 0x02, 0xa1, 0x02,
            0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00, 0x4c, 0x00,
            0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00,
            0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x23, 0x00, 0x4c, 0x00,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01,
            0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0x9b, 0x01, 0xa2, 0x02
        };

        private static ReadOnlySpan<byte> CategoryLevel3Index => new byte[10800]
        {
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x04, 0x03, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03, 0x03, 0x02,
            0x05, 0x06, 0x06, 0x07, 0x08, 0x07, 0x06, 0x06, 0x09, 0x0a, 0x06, 0x0b, 0x0c, 0x0d, 0x0c, 0x0c,
            0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0c, 0x06, 0x0f, 0x0f, 0x0f, 0x06,
            0x06, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x09, 0x06, 0x0a, 0x11, 0x12,
            0x11, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x09, 0x0f, 0x0a, 0x0f, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x14, 0x06, 0x08, 0x08, 0x08, 0x08, 0x15, 0x06, 0x11, 0x15, 0x16, 0x17, 0x0f, 0x18, 0x15, 0x11,
            0x19, 0x1a, 0x1b, 0x1b, 0x11, 0x13, 0x06, 0x06, 0x11, 0x1b, 0x16, 0x1c, 0x1d, 0x1d, 0x1d, 0x06,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x0f, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10,
            0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x13,
            0x13, 0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x13, 0x10, 0x10, 0x10, 0x13, 0x13, 0x10, 0x10,
            0x10, 0x10, 0x13, 0x10, 0x10, 0x13, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x10, 0x10, 0x13, 0x10,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x13, 0x10, 0x13, 0x13, 0x10, 0x13, 0x10, 0x10,
            0x13, 0x10, 0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x13, 0x13, 0x16, 0x10, 0x13, 0x13, 0x13,
            0x16, 0x16, 0x16, 0x16, 0x10, 0x1e, 0x13, 0x10, 0x1e, 0x13, 0x10, 0x1e, 0x13, 0x10, 0x13, 0x10,
            0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x13, 0x10, 0x13,
            0x13, 0x10, 0x1e, 0x13, 0x10, 0x13, 0x10, 0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x10, 0x13, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x13, 0x10, 0x10, 0x13,
            0x13, 0x10, 0x13, 0x10, 0x10, 0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x16, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x20, 0x20, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
            0x1f, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
            0x1f, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
            0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x11, 0x1f, 0x11,
            0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x10, 0x13, 0x10, 0x13, 0x20, 0x11, 0x10, 0x13, 0x00, 0x00, 0x1f, 0x13, 0x13, 0x13, 0x06, 0x10,
            0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x10, 0x06, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x10, 0x10,
            0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10,
            0x13, 0x13, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x10, 0x13, 0x0f, 0x10, 0x13, 0x10, 0x10, 0x13, 0x13, 0x10, 0x10, 0x10,
            0x10, 0x13, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21, 0x23, 0x23, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x13,
            0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x1f, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x24, 0x25, 0x00, 0x00, 0x15, 0x15, 0x08,
            0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x26, 0x21,
            0x27, 0x21, 0x21, 0x27, 0x21, 0x21, 0x27, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x28,
            0x28, 0x28, 0x28, 0x27, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x0f, 0x0f, 0x2a, 0x07, 0x07, 0x2b, 0x0c, 0x2c, 0x15, 0x15,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x2c, 0x2d, 0x00, 0x2c, 0x2c,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2f, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x07, 0x31, 0x31, 0x2c, 0x2e, 0x2e,
            0x21, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2c, 0x2e, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x29, 0x15, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x2f, 0x2f, 0x21, 0x21, 0x15, 0x21, 0x21, 0x21, 0x21, 0x2e, 0x2e,
            0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x2e, 0x2e, 0x2e, 0x32, 0x32, 0x2e,
            0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x00, 0x2d,
            0x2e, 0x21, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x34, 0x34, 0x15, 0x06, 0x06, 0x06, 0x34, 0x00, 0x00, 0x21, 0x35, 0x35,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x21, 0x21, 0x21, 0x21, 0x34, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x34, 0x21, 0x21, 0x21, 0x34, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00,
            0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x00,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x21, 0x21, 0x21, 0x00, 0x00, 0x27, 0x00,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x29, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x36, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x36, 0x21, 0x16, 0x36, 0x36,
            0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x36, 0x36, 0x21, 0x36, 0x36,
            0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x21, 0x21, 0x24, 0x24, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
            0x24, 0x1f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x21, 0x36, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16,
            0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x21, 0x16, 0x36, 0x36,
            0x36, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x21, 0x16, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x00, 0x16,
            0x16, 0x16, 0x21, 0x21, 0x00, 0x00, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
            0x16, 0x16, 0x08, 0x08, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x22, 0x08, 0x16, 0x24, 0x21, 0x00,
            0x00, 0x21, 0x21, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x16,
            0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x00, 0x00, 0x21, 0x00, 0x36, 0x36,
            0x36, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x00, 0x00, 0x21, 0x21, 0x21, 0x00, 0x00,
            0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
            0x21, 0x21, 0x16, 0x16, 0x16, 0x21, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x21, 0x21, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16,
            0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x21, 0x16, 0x36, 0x36,
            0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x36, 0x00, 0x36, 0x36, 0x21, 0x00, 0x00,
            0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x24, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x00, 0x21, 0x36, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16,
            0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x21, 0x16, 0x36, 0x21,
            0x36, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x21, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x36, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x00, 0x16,
            0x22, 0x16, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x21, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x16, 0x16,
            0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x16,
            0x00, 0x00, 0x00, 0x16, 0x16, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36,
            0x21, 0x36, 0x36, 0x00, 0x00, 0x00, 0x36, 0x36, 0x36, 0x00, 0x36, 0x36, 0x36, 0x21, 0x00, 0x00,
            0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x38, 0x38, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x36, 0x36, 0x36, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16,
            0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x16, 0x21, 0x21,
            0x21, 0x36, 0x36, 0x36, 0x36, 0x00, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x00, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x22,
            0x16, 0x21, 0x36, 0x36, 0x24, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x21, 0x16, 0x36, 0x39,
            0x36, 0x36, 0x36, 0x36, 0x36, 0x00, 0x39, 0x36, 0x36, 0x00, 0x36, 0x36, 0x21, 0x21, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x00,
            0x00, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x36, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x16, 0x36, 0x36,
            0x36, 0x21, 0x21, 0x21, 0x21, 0x00, 0x36, 0x36, 0x36, 0x00, 0x36, 0x36, 0x36, 0x21, 0x16, 0x22,
            0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x36, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x16,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x22, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x00, 0x00, 0x36, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0x36,
            0x36, 0x36, 0x21, 0x21, 0x21, 0x00, 0x21, 0x00, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
            0x00, 0x00, 0x36, 0x36, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x21, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x08,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x1f, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x00, 0x16, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x00, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16,
            0x16, 0x21, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x16, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x1f, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x22, 0x22, 0x22, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x22, 0x24, 0x22, 0x22, 0x22, 0x21, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x38, 0x38, 0x38, 0x38, 0x22, 0x21, 0x22, 0x21, 0x22, 0x21, 0x09, 0x0a, 0x09, 0x0a, 0x36, 0x36,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00,
            0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x22, 0x22,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 0x22, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x21, 0x21, 0x21,
            0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x16,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21,
            0x21, 0x16, 0x36, 0x36, 0x36, 0x16, 0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x16, 0x16,
            0x16, 0x21, 0x21, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x21, 0x36, 0x36, 0x21, 0x21, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x16, 0x36,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x36, 0x36, 0x36, 0x21, 0x22, 0x22,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x24, 0x1f, 0x13, 0x13, 0x13,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00,
            0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00,
            0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x21, 0x21, 0x21,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00,
            0x25, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x24, 0x24, 0x16,
            0x05, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x09, 0x0a, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x24, 0x24, 0x24, 0x3a, 0x3a,
            0x3a, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16,
            0x16, 0x16, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x21, 0x21, 0x21, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x00, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36,
            0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x1f, 0x24, 0x24, 0x24, 0x08, 0x16, 0x21, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x25, 0x06, 0x06, 0x06, 0x06, 0x21, 0x21, 0x21, 0x18, 0x00,
            0x16, 0x16, 0x16, 0x1f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00,
            0x21, 0x21, 0x21, 0x36, 0x36, 0x36, 0x36, 0x21, 0x21, 0x36, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00,
            0x36, 0x36, 0x21, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x00, 0x00, 0x00, 0x06, 0x06, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x38, 0x00, 0x00, 0x00, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x36, 0x36, 0x21, 0x00, 0x00, 0x24, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00,
            0x21, 0x36, 0x21, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x36,
            0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x21,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x1f, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x23, 0x00,
            0x21, 0x21, 0x21, 0x21, 0x36, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x36, 0x36, 0x36,
            0x36, 0x36, 0x21, 0x36, 0x36, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
            0x24, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x36, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x36, 0x21, 0x21, 0x21, 0x16, 0x16,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x36, 0x21, 0x21, 0x36, 0x36, 0x36, 0x21, 0x36, 0x21,
            0x21, 0x21, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x00, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x24, 0x24,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x24, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x21, 0x16, 0x16,
            0x16, 0x16, 0x36, 0x36, 0x21, 0x16, 0x16, 0x36, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1f, 0x1f, 0x1f, 0x1f,
            0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
            0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1f, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10, 0x00, 0x10,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x13, 0x11,
            0x11, 0x11, 0x13, 0x13, 0x13, 0x00, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11,
            0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x00, 0x11, 0x11, 0x11,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0x11,
            0x00, 0x00, 0x13, 0x13, 0x13, 0x00, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x00,
            0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x18, 0x18, 0x18, 0x3b, 0x3c,
            0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x06, 0x06, 0x17, 0x1c, 0x09, 0x17, 0x17, 0x1c, 0x09, 0x17,
            0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x3d, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x14,
            0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x06, 0x06, 0x06, 0x17, 0x1c, 0x06, 0x06, 0x06, 0x06, 0x12,
            0x12, 0x06, 0x06, 0x06, 0x44, 0x09, 0x0a, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
            0x06, 0x06, 0x0f, 0x06, 0x12, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x05,
            0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x45, 0x46, 0x47, 0x48, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
            0x1b, 0x1f, 0x00, 0x00, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0b, 0x0b, 0x0f, 0x09, 0x0a, 0x1f,
            0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x0b, 0x0b, 0x0f, 0x09, 0x0a, 0x00,
            0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x00, 0x00,
            0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x23, 0x23, 0x23,
            0x23, 0x21, 0x23, 0x23, 0x23, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x10, 0x15, 0x15, 0x15, 0x15, 0x10, 0x15, 0x15, 0x13, 0x10, 0x10, 0x10, 0x13, 0x13,
            0x10, 0x10, 0x10, 0x13, 0x15, 0x10, 0x15, 0x15, 0x0f, 0x10, 0x10, 0x10, 0x10, 0x10, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x10, 0x15, 0x10, 0x15, 0x10, 0x15, 0x10, 0x10, 0x10, 0x10, 0x19, 0x13,
            0x10, 0x10, 0x10, 0x10, 0x13, 0x16, 0x16, 0x16, 0x16, 0x13, 0x15, 0x15, 0x13, 0x13, 0x10, 0x10,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x10, 0x13, 0x13, 0x13, 0x13, 0x15, 0x0f, 0x15, 0x15, 0x13, 0x22,
            0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
            0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a,
            0x3a, 0x3a, 0x3a, 0x10, 0x13, 0x3a, 0x3a, 0x3a, 0x3a, 0x1d, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x0f, 0x15, 0x15, 0x15, 0x15,
            0x0f, 0x15, 0x15, 0x0f, 0x15, 0x15, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x0f,
            0x15, 0x15, 0x0f, 0x15, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0b, 0x1a, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x09, 0x0a, 0x09, 0x0a, 0x15, 0x15, 0x15, 0x15,
            0x0f, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x09, 0x0a, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x0f, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x22, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0f, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
            0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x22, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a,
            0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
            0x1d, 0x1d, 0x1d, 0x1d, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x09, 0x0a, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a,
            0x0f, 0x0f, 0x0f, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09,
            0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x09, 0x0a, 0x09, 0x0a, 0x0f, 0x0f, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x09, 0x0a, 0x0f, 0x0f,
            0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x15, 0x15, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00,
            0x10, 0x13, 0x10, 0x10, 0x10, 0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x10,
            0x10, 0x13, 0x10, 0x13, 0x13, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x1f, 0x1f, 0x10, 0x10,
            0x10, 0x13, 0x10, 0x13, 0x13, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x10, 0x13, 0x10, 0x13, 0x21,
            0x21, 0x21, 0x10, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x1d, 0x06, 0x06,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
            0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00,
            0x06, 0x06, 0x17, 0x1c, 0x17, 0x1c, 0x06, 0x06, 0x06, 0x17, 0x1c, 0x06, 0x17, 0x1c, 0x06, 0x06,
            0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x25, 0x06, 0x06, 0x25, 0x06, 0x17, 0x1c, 0x06, 0x06,
            0x17, 0x1c, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x06, 0x06, 0x06, 0x06, 0x06, 0x20,
            0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x25, 0x25, 0x06, 0x06, 0x06, 0x06,
            0x25, 0x06, 0x09, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00,
            0x05, 0x06, 0x06, 0x06, 0x15, 0x1f, 0x16, 0x3a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a,
            0x09, 0x0a, 0x15, 0x15, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x25, 0x09, 0x0a, 0x0a,
            0x15, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36,
            0x25, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x15, 0x15, 0x3a, 0x3a, 0x3a, 0x1f, 0x16, 0x06, 0x15, 0x15,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x21, 0x21, 0x11, 0x11, 0x1f, 0x1f, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x06, 0x1f, 0x1f, 0x1f, 0x16,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x22, 0x22, 0x38, 0x38, 0x38, 0x38, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x15, 0x00,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x15, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x15, 0x15, 0x22,
            0x22, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x15, 0x15, 0x15,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x15, 0x15, 0x15, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x15,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x1f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x1f, 0x06, 0x06, 0x06,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x16, 0x21,
            0x23, 0x23, 0x23, 0x06, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x06, 0x20,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x1f, 0x1f, 0x21, 0x21,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a,
            0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
            0x11, 0x11, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x1f, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x13,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x20, 0x49, 0x49, 0x10, 0x13, 0x10, 0x13, 0x16,
            0x10, 0x13, 0x10, 0x13, 0x13, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13,
            0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x10, 0x13, 0x10, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x1f, 0x1f, 0x13, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x21, 0x16, 0x16, 0x16, 0x21, 0x16, 0x16, 0x16, 0x16, 0x21, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x36, 0x36, 0x21, 0x21, 0x36, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x22, 0x22, 0x08, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x36, 0x36, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
            0x36, 0x36, 0x36, 0x36, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
            0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x24, 0x24, 0x24, 0x16, 0x24, 0x16, 0x16, 0x21,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24,
            0x16, 0x16, 0x16, 0x21, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x36, 0x36, 0x36,
            0x36, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x1f,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x00, 0x00, 0x00, 0x24, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x1f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36,
            0x36, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x36, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x00, 0x24, 0x24, 0x24, 0x24,
            0x1f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x22, 0x22, 0x22, 0x16, 0x36, 0x21, 0x36, 0x16, 0x16,
            0x21, 0x16, 0x21, 0x21, 0x21, 0x16, 0x16, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21,
            0x16, 0x21, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x1f, 0x24, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x21, 0x21, 0x36, 0x36,
            0x24, 0x24, 0x16, 0x1f, 0x1f, 0x36, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00,
            0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x49, 0x1f, 0x1f, 0x1f, 0x1f,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x36, 0x36, 0x21, 0x36, 0x36, 0x21, 0x36, 0x36, 0x24, 0x36, 0x21, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a,
            0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x21, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x0b, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x28, 0x00,
            0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x2e, 0x2e, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c, 0x4c,
            0x4c, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x0a, 0x09,
            0x00, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2b, 0x15, 0x00, 0x00,
            0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x09, 0x0a, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x06, 0x25, 0x25, 0x12, 0x12, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x09,
            0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x06, 0x06, 0x09, 0x0a, 0x06, 0x06, 0x06, 0x06, 0x12, 0x12, 0x12,
            0x0c, 0x06, 0x0c, 0x00, 0x06, 0x0c, 0x06, 0x06, 0x25, 0x09, 0x0a, 0x09, 0x0a, 0x09, 0x0a, 0x07,
            0x06, 0x06, 0x0b, 0x0d, 0x0f, 0x0f, 0x0f, 0x00, 0x06, 0x08, 0x07, 0x06, 0x00, 0x00, 0x00, 0x00,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x18,
            0x00, 0x06, 0x06, 0x07, 0x08, 0x07, 0x06, 0x06, 0x09, 0x0a, 0x06, 0x0b, 0x0c, 0x0d, 0x0c, 0x0c,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x09, 0x0f, 0x0a, 0x0f, 0x09,
            0x0a, 0x06, 0x09, 0x0a, 0x06, 0x06, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x1f, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x1f, 0x1f,
            0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00,
            0x08, 0x08, 0x0f, 0x11, 0x15, 0x08, 0x08, 0x00, 0x15, 0x0f, 0x0f, 0x0f, 0x0f, 0x15, 0x15, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x4d, 0x4d, 0x15, 0x15, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x00, 0x16,
            0x24, 0x06, 0x24, 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e,
            0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x1d, 0x1d, 0x1d, 0x1d, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x1d, 0x1d, 0x15, 0x22, 0x22, 0x00,
            0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x00, 0x00,
            0x21, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b,
            0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16,
            0x16, 0x3a, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x24,
            0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x24, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x28, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x27, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x50, 0x50, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x06,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x28, 0x28,
            0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21,
            0x28, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x28, 0x00, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x21,
            0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x4f, 0x4f, 0x27,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x50, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x27, 0x27, 0x27, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51,
            0x51, 0x51, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
            0x52, 0x52, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x2e, 0x2e, 0x2e, 0x2e, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53,
            0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x00,
            0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x54, 0x54, 0x54, 0x54, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x36, 0x21, 0x36, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00,
            0x00, 0x00, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d,
            0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
            0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x24, 0x24, 0x3b, 0x24, 0x24,
            0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37,
            0x24, 0x24, 0x24, 0x24, 0x16, 0x36, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x21, 0x24, 0x24, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36,
            0x36, 0x16, 0x16, 0x16, 0x16, 0x24, 0x24, 0x24, 0x24, 0x21, 0x21, 0x21, 0x21, 0x24, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x16, 0x24, 0x16, 0x24, 0x24, 0x24,
            0x00, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x36, 0x21,
            0x21, 0x21, 0x36, 0x36, 0x21, 0x36, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21,
            0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x36, 0x36, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16,
            0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x21, 0x21, 0x16, 0x36, 0x36,
            0x21, 0x36, 0x36, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x00, 0x00, 0x36, 0x36, 0x36, 0x00, 0x00,
            0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x36, 0x36, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x36, 0x36, 0x21, 0x21, 0x21, 0x36, 0x21, 0x16, 0x16, 0x16, 0x16, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x24, 0x00, 0x24, 0x21, 0x00,
            0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x36, 0x36, 0x36, 0x36, 0x21,
            0x21, 0x36, 0x21, 0x21, 0x16, 0x16, 0x24, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x36,
            0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x36, 0x36, 0x36, 0x36, 0x21, 0x21, 0x36, 0x21,
            0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x00, 0x00,
            0x36, 0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x36, 0x21,
            0x21, 0x24, 0x24, 0x24, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x21, 0x36, 0x21, 0x36, 0x36,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x36, 0x36, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x38, 0x38, 0x24, 0x24, 0x24, 0x22,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21, 0x24, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16,
            0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x39, 0x39, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x16, 0x21, 0x21, 0x21, 0x21, 0x24,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x36, 0x21, 0x21, 0x21, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x16, 0x16, 0x16, 0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x21, 0x21, 0x24, 0x24, 0x24, 0x16, 0x24, 0x24,
            0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x36, 0x39,
            0x16, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x24, 0x24, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x36, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x36, 0x21, 0x21, 0x36, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x21, 0x00, 0x21, 0x21, 0x00, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x16, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x16, 0x16, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00,
            0x21, 0x21, 0x00, 0x36, 0x36, 0x21, 0x36, 0x21, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x21, 0x21, 0x36, 0x36, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x00,
            0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x24, 0x24, 0x24, 0x22, 0x22, 0x22, 0x22,
            0x1f, 0x1f, 0x1f, 0x1f, 0x24, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x37, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38,
            0x38, 0x38, 0x00, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x16, 0x16,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
            0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
            0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00,
            0x21, 0x21, 0x21, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
            0x1f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x16, 0x00, 0x00, 0x22, 0x21, 0x21, 0x24,
            0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x36, 0x36, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x36, 0x36, 0x36,
            0x36, 0x36, 0x36, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x21, 0x21, 0x21, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x00, 0x10, 0x10,
            0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x00, 0x13, 0x00, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x00, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x00, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x55, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x0f, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x55, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x0f, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x55, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x0f,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x55,
            0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x0f, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x55, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
            0x13, 0x13, 0x13, 0x0f, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x10, 0x13, 0x00, 0x00, 0x0e, 0x0e,
            0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e, 0x0e,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x22, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x22, 0x21, 0x22, 0x22, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21,
            0x21, 0x21, 0x00, 0x21, 0x21, 0x00, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x28, 0x28, 0x28, 0x28, 0x28, 0x00, 0x00, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f,
            0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52,
            0x52, 0x52, 0x52, 0x52, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x27, 0x27,
            0x00, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54,
            0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54,
            0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x32, 0x54, 0x54, 0x54,
            0x2b, 0x54, 0x54, 0x54, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x00, 0x2e, 0x2e, 0x00, 0x2e, 0x00, 0x00, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x2e, 0x2e, 0x2e,
            0x00, 0x2e, 0x2e, 0x00, 0x2e, 0x00, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x2e, 0x00, 0x2e,
            0x00, 0x2e, 0x2e, 0x00, 0x2e, 0x00, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x00,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e, 0x00, 0x2e, 0x2e, 0x2e, 0x2e, 0x2e,
            0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
            0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1b, 0x1d, 0x1d, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
            0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00,
            0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x11, 0x11, 0x11, 0x11, 0x11,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00,
            0x15, 0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x15, 0x00, 0x15, 0x15, 0x15, 0x15,
            0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
            0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x00, 0x00
        };

        private static ReadOnlySpan<byte> CategoriesValue => new byte[172]
        {
            0x1d, 0x00, 0x0e, 0x0e, 0x0e, 0x10, 0x0e, 0x0f, 0x0e, 0x11, 0x0b, 0x11, 0x18, 0x12, 0x18, 0x0a,
            0x1a, 0x0a, 0x14, 0x12, 0x15, 0x12, 0x19, 0x09, 0x18, 0x0c, 0x13, 0x09, 0x08, 0x08, 0x19, 0x12,
            0x00, 0x00, 0x1b, 0x12, 0x12, 0x12, 0x01, 0x00, 0x0b, 0x0c, 0x1c, 0x12, 0x04, 0x00, 0x16, 0x12,
            0x0f, 0x0e, 0x1c, 0x0a, 0x19, 0x0a, 0x0a, 0x08, 0x17, 0x12, 0x0a, 0x12, 0x02, 0x00, 0x03, 0x00,
            0x03, 0x12, 0x05, 0x0d, 0x1c, 0x00, 0x07, 0x0d, 0x18, 0x00, 0x13, 0x12, 0x13, 0x03, 0x18, 0x03,
            0x04, 0x03, 0x0f, 0x0b, 0x19, 0x04, 0x1a, 0x04, 0x18, 0x04, 0x0f, 0x04, 0x04, 0x04, 0x03, 0x04,
            0x08, 0x0b, 0x18, 0x0b, 0x1c, 0x04, 0x08, 0x03, 0x03, 0x03, 0x1a, 0x03, 0x06, 0x00, 0x08, 0x00,
            0x0a, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0f, 0x00, 0x0f, 0x03, 0x0c, 0x11, 0x0d, 0x0f, 0x0f, 0x01,
            0x0f, 0x05, 0x0f, 0x07, 0x0f, 0x02, 0x0f, 0x06, 0x19, 0x0c, 0x0f, 0x13, 0x0f, 0x14, 0x0f, 0x15,
            0x0f, 0x16, 0x1b, 0x00, 0x10, 0x00, 0x11, 0x00, 0x1b, 0x04, 0x0f, 0x12, 0x09, 0x12, 0x0a, 0x03,
            0x1c, 0x03, 0x00, 0x03, 0x01, 0x03, 0x0a, 0x0b, 0x0a, 0x04, 0x19, 0x00
        };

        // 12:4:4 index table of the Unicode numeric data.
        private static ReadOnlySpan<byte> NumericLevel1Index => new byte[761]
        {
            0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
            0x0b, 0x01, 0x01, 0x0c, 0x01, 0x01, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x01, 0x01, 0x01,
            0x14, 0x15, 0x01, 0x01, 0x16, 0x01, 0x01, 0x17, 0x01, 0x01, 0x01, 0x01, 0x18, 0x01, 0x01, 0x01,
            0x19, 0x1a, 0x1b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1c, 0x01, 0x1d, 0x1e, 0x1f, 0x20, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f,
            0x01, 0x22, 0x23, 0x24, 0x25, 0x01, 0x01, 0x01, 0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d,
            0x2e, 0x2f, 0x20, 0x01, 0x09, 0x01, 0x30, 0x31, 0x32, 0x01, 0x01, 0x01, 0x33, 0x34, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x35, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x37, 0x01, 0x01, 0x38, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x39, 0x3a, 0x01, 0x01, 0x01, 0x3b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3c, 0x1f, 0x01, 0x01, 0x3d, 0x01, 0x01, 0x01,
            0x01, 0x3e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
            0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3f
        };

        private static ReadOnlySpan<byte> NumericLevel2Index => new byte[1024]
        {
            0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x04,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x03, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x00, 0x00, 0x0a, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10,
            0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x15, 0x15, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x18, 0x19, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x1c,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0x1e, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
            0x21, 0x00, 0x22, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x25, 0x00, 0x26, 0x27, 0x00, 0x00, 0x25, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x00,
            0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
            0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x2c, 0x00, 0x00, 0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f,
            0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x3a,
            0x00, 0x00, 0x3b, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x41,
            0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x44, 0x45, 0x46, 0x47,
            0x00, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x49, 0x00, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x41, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x4b, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d,
            0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x50, 0x51, 0x00, 0x00, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x53, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
            0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x39, 0x55,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x58,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x66,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x69, 0x6a, 0x6b,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x6c, 0x6d, 0x6e, 0x6f, 0x00, 0x00, 0x00, 0x00,
            0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };

        private static ReadOnlySpan<byte> NumericLevel3Index => new byte[1824]
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x0b, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x0e, 0x0f, 0x10, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
            0x00, 0x00, 0x00, 0x00, 0x11, 0x12, 0x13, 0x0e, 0x10, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x15, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x19, 0x1a, 0x1b, 0x19, 0x1a, 0x1b, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x00,
            0x15, 0x16, 0x17, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0f, 0x23, 0x24, 0x25, 0x26, 0x27,
            0x28, 0x29, 0x2a, 0x2b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f,
            0x30, 0x31, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x16, 0x3a, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x3c,
            0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x18, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x44, 0x00, 0x00, 0x00, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x44, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x45, 0x46, 0x20, 0x47, 0x48, 0x22, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x12, 0x4e, 0x4f, 0x50, 0x19,
            0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x15, 0x51, 0x52, 0x35, 0x16, 0x53, 0x17,
            0x17, 0x54, 0x3a, 0x00, 0x00, 0x40, 0x35, 0x55, 0x56, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15, 0x51, 0x52, 0x57, 0x58, 0x59, 0x14,
            0x3b, 0x3c, 0x3d, 0x32, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15, 0x51, 0x52,
            0x57, 0x58, 0x59, 0x14, 0x3b, 0x3c, 0x3d, 0x32, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30,
            0x31, 0x15, 0x51, 0x52, 0x57, 0x58, 0x59, 0x14, 0x3b, 0x3c, 0x3d, 0x32, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x51, 0x52, 0x57, 0x58, 0x59,
            0x14, 0x3b, 0x3c, 0x3d, 0x32, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15, 0x44,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15,
            0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e,
            0x2f, 0x30, 0x31, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x32, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38,
            0x00, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62, 0x33, 0x63, 0x64, 0x65, 0x66, 0x67,
            0x00, 0x68, 0x69, 0x6a, 0x6b, 0x34, 0x6c, 0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x35,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x18,
            0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x40, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43,
            0x15, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x16, 0x75, 0x76, 0x77, 0x53, 0x78, 0x79,
            0x7a, 0x7b, 0x17, 0x7c, 0x7d, 0x7e, 0x54, 0x7f, 0x80, 0x81, 0x82, 0x3a, 0x83, 0x84, 0x85, 0x55,
            0x86, 0x87, 0x88, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x0e, 0x0f, 0x19, 0x3f, 0x35, 0x53, 0x54, 0x55, 0x3f, 0x15, 0x35, 0x16, 0x53, 0x17, 0x54, 0x3f,
            0x15, 0x35, 0x16, 0x53, 0x17, 0x3a, 0x55, 0x15, 0x19, 0x19, 0x19, 0x1a, 0x1a, 0x1a, 0x1a, 0x3f,
            0x15, 0x15, 0x15, 0x15, 0x15, 0x33, 0x35, 0x35, 0x35, 0x35, 0x16, 0x76, 0x53, 0x53, 0x53, 0x53,
            0x53, 0x17, 0x54, 0x3f, 0x35, 0x0f, 0x0f, 0x48, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x0e, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36,
            0x37, 0x38, 0x39, 0x16, 0x75, 0x76, 0x77, 0x53, 0x78, 0x79, 0x7a, 0x7b, 0x00, 0x00, 0x00, 0x00,
            0x19, 0x3f, 0x15, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x19, 0x1a, 0x15, 0x32, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x15, 0x32, 0x16, 0x17, 0x3a,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x15, 0x32,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x3e, 0x3f, 0x15, 0x32, 0x16,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x3f, 0x15, 0x32, 0x16,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x15, 0x32, 0x16, 0x1a, 0x1b, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x0f, 0x00, 0x00,
            0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
            0x00, 0x00, 0x16, 0x75, 0x76, 0x77, 0x53, 0x78, 0x79, 0x7a, 0x7b, 0x17, 0x7c, 0x7d, 0x7e, 0x54,
            0x7f, 0x80, 0x81, 0x82, 0x3a, 0x83, 0x84, 0x85, 0x55, 0x86, 0x87, 0x88, 0x89, 0x56, 0x8b, 0x8c,
            0x8d, 0x8e, 0x8f, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9b, 0x9c,
            0x0d, 0x0b, 0x0c, 0x2c, 0x15, 0x32, 0x16, 0x17, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x35, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x15, 0x32,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x15, 0x32, 0x16, 0x17,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b, 0x3e, 0x15, 0x32, 0x16,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x3f, 0x15, 0x35, 0x16, 0x17,
            0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
            0x38, 0x39, 0x16, 0x75, 0x76, 0x77, 0x53, 0x78, 0x79, 0x7a, 0x7b, 0x0f, 0x0e, 0x47, 0x48, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x1a, 0x1b,
            0x3e, 0x3f, 0x15, 0x32, 0x33, 0x16, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x19, 0x15, 0x32, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x15, 0x32, 0x33, 0x34, 0x35,
            0x36, 0x37, 0x38, 0x39, 0x16, 0x17, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
            0x37, 0x38, 0x39, 0x16, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x15, 0x32, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36,
            0x37, 0x38, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40,
            0x41, 0x42, 0x43, 0x15, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x16, 0x00, 0x00, 0x00,
            0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x3e,
            0x3f, 0x40, 0x41, 0x42, 0x43, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x19, 0x1a,
            0x1b, 0x3e, 0x3f, 0x1a, 0x1b, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x19, 0x1a, 0x1b, 0x1b,
            0x3e, 0x3f, 0x9d, 0x9e, 0x19, 0x1a, 0x1b, 0x1b, 0x3e, 0x3f, 0x1b, 0x1b, 0x3e, 0x3e, 0x3e, 0x3e,
            0x40, 0x41, 0x41, 0x41, 0x42, 0x42, 0x43, 0x43, 0x43, 0x43, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x19,
            0x1a, 0x1b, 0x3e, 0x3e, 0x3f, 0x3f, 0x1a, 0x1b, 0x19, 0x1a, 0x47, 0x48, 0x4d, 0x47, 0x48, 0x12,
            0x0e, 0x4c, 0x0e, 0x0e, 0x0f, 0x47, 0x48, 0x34, 0x35, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x00,
            0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x00, 0x15, 0x16, 0x3a, 0x9f, 0xa0,
            0xa1, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x18, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x15, 0x51, 0x52, 0x57, 0x58, 0x59,
            0x14, 0x3b, 0x3c, 0x3d, 0x19, 0x1a, 0x1b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x14, 0x3b, 0x3c, 0x3d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x38, 0x39, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x19, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02,
            0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
            0x09, 0x0a, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x01, 0x02, 0x03, 0x04,
            0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
            0x37, 0x38, 0x39, 0x16, 0x75, 0x76, 0x77, 0x53, 0x78, 0x79, 0x7a, 0x7b, 0x17, 0x7c, 0x7d, 0x7e,
            0x54, 0x7f, 0x80, 0x81, 0x82, 0x3a, 0x83, 0x84, 0x85, 0x55, 0x86, 0x87, 0x88, 0x89, 0x56, 0x8b,
            0x56, 0xa3, 0xa4, 0x19, 0x1a, 0x1b, 0x3e, 0x3f, 0x40, 0x41, 0x42, 0x43, 0x00, 0x0e, 0x0f, 0x10,
            0x00, 0x19, 0x1a, 0x3a, 0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x44, 0x44, 0x0d, 0x0b, 0x0c, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x18, 0x18, 0x00, 0x00, 0x00,
            0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
        };

        // Every item contains the value for numeric value.
        private static ReadOnlySpan<byte> NumericValues => new byte[1320]
        {
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc8, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x8f, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x40,
            0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0x79, 0x3f, 0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x3f,
            0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xa3, 0x3f, 0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0xa9, 0x3f,
            0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0xb9, 0x3f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xc3, 0x3f,
            0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0xc9, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xbf,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4e, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x51, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x56, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xc3, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x92, 0x24, 0x49, 0x92, 0x24, 0x49, 0xc2, 0x3f,
            0x1c, 0xc7, 0x71, 0x1c, 0xc7, 0x71, 0xbc, 0x3f, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 0x3f,
            0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xe5, 0x3f, 0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0xd9, 0x3f,
            0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0xe3, 0x3f, 0x9a, 0x99, 0x99, 0x99, 0x99, 0x99, 0xe9, 0x3f,
            0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xc5, 0x3f, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe4, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x26, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x7f, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xb3, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xe8, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0xf8, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3a, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x41, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x41, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x42, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x42, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x43, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x44, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x45, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x46, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x47, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x48, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x69, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x72, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x82, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x85, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x89, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x8c, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x9f, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xa7, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xaf, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xb7, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0xbb, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xbf, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x94, 0xc1, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xd3, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xdd, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xe3, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0xed, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xf1, 0x40,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x88, 0xf3, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf9, 0xf5, 0x40,
            0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xed, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x08, 0x41,
            0x00, 0x00, 0x00, 0x00, 0x80, 0x4f, 0x12, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x18, 0x41,
            0x00, 0x00, 0x00, 0x00, 0x80, 0x84, 0x1e, 0x41, 0x00, 0x00, 0x00, 0x00, 0x80, 0x4f, 0x22, 0x41,
            0x00, 0x00, 0x00, 0x00, 0xc0, 0x5c, 0x25, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6a, 0x28, 0x41,
            0x00, 0x00, 0x00, 0x00, 0x40, 0x77, 0x2b, 0x41, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xb5, 0x3f,
            0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xc5, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x3f,
            0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xd5, 0x3f, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xda, 0x3f,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f, 0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xe2, 0x3f,
            0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0xe5, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe8, 0x3f,
            0xab, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xea, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x0a, 0x41,
            0x00, 0x00, 0x00, 0x00, 0x00, 0x5e, 0x1a, 0x41, 0x00, 0x00, 0x00, 0x00, 0x80, 0x84, 0x2e, 0x41,
            0x00, 0x00, 0x00, 0x00, 0x84, 0xd7, 0x97, 0x41, 0x00, 0x00, 0x00, 0x20, 0x5f, 0xa0, 0x02, 0x42,
            0x00, 0x00, 0x00, 0xa2, 0x94, 0x1a, 0x6d, 0x42, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x12, 0x63, 0x41,
            0x00, 0x00, 0x00, 0x00, 0xd0, 0x12, 0x73, 0x41
        };

        private static ReadOnlySpan<byte> DigitValues => new byte[330]
        {
            0xff, 0xff, 0x00, 0x00, 0x01, 0x01, 0x02, 0x02, 0x03, 0x03, 0x04, 0x04, 0x05, 0x05, 0x06, 0x06,
            0x07, 0x07, 0x08, 0x08, 0x09, 0x09, 0xff, 0x02, 0xff, 0x03, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x04, 0xff, 0x05, 0xff, 0x06, 0xff, 0x07,
            0xff, 0x08, 0xff, 0x09, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
            0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
        };
    }
}
